/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.svg4everybody.web.internal.servlet.taglib;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.servlet.taglib.BaseDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilderFactory;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=2147483647"}, service={DynamicInclude.class})
public class SVG4EverybodyTopHeadDynamicInclude
extends BaseDynamicInclude {
    private static final String[] _JS_FILE_NAMES = new String[]{"/index.js"};
    private static final Log _log = LogFactoryUtil.getLog(SVG4EverybodyTopHeadDynamicInclude.class);
    @Reference
    private AbsolutePortalURLBuilderFactory _absolutePortalURLBuilderFactory;
    @Reference
    private BrowserSniffer _browserSniffer;
    private BundleContext _bundleContext;
    @Reference
    private Portal _portal;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        boolean cdnHostEnabled;
        boolean cdnDynamicResourcesEnabled;
        block8: {
            block7: {
                cdnDynamicResourcesEnabled = true;
                try {
                    cdnDynamicResourcesEnabled = this._portal.isCDNDynamicResourcesEnabled(httpServletRequest);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)"Unable to verify if CDN dynamic resources are enabled", (Throwable)portalException);
                }
            }
            cdnHostEnabled = false;
            try {
                String cdnHost = this._portal.getCDNHost(httpServletRequest);
                cdnHostEnabled = !cdnHost.isEmpty();
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)"Unable to get CDN host", (Throwable)portalException);
            }
        }
        if (cdnHostEnabled || this._browserSniffer.isIe(httpServletRequest)) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            AbsolutePortalURLBuilder absolutePortalURLBuilder = this._absolutePortalURLBuilderFactory.getAbsolutePortalURLBuilder(httpServletRequest);
            if (!cdnDynamicResourcesEnabled) {
                absolutePortalURLBuilder.ignoreCDNHost();
            }
            for (String jsFileName : _JS_FILE_NAMES) {
                printWriter.print("<script data-senna-track=\"permanent\" src=\"");
                printWriter.print(absolutePortalURLBuilder.forModule(this._bundleContext.getBundle(), jsFileName).build());
                printWriter.println("\" type=\"text/javascript\"></script>");
            }
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_head.jsp#pre");
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }
}

