Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.11/_createFind', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseIteratee from './_baseIteratee.js';
  import isArrayLike from './isArrayLike.js';
  import keys from './keys.js';

  /**
   * Creates a `_.find` or `_.findLast` function.
   *
   * @private
   * @param {Function} findIndexFunc The function to find the collection index.
   * @returns {Function} Returns the new find function.
   */
  function createFind(findIndexFunc) {
    return function (collection, predicate, fromIndex) {
      var iterable = Object(collection);
      if (!isArrayLike(collection)) {
        var iteratee = baseIteratee(predicate, 3);
        collection = keys(collection);
        predicate = function (key) {
          return iteratee(iterable[key], key, iterable);
        };
      }
      var index = findIndexFunc(collection, predicate, fromIndex);
      return index > -1 ? iterable[iteratee ? collection[index] : index] : undefined;
    };
  }

  export default createFind;
});
//# sourceMappingURL=_createFind.js.map