Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.11/isWeakSet', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseGetTag from './_baseGetTag.js';
  import isObjectLike from './isObjectLike.js';

  /** `Object#toString` result references. */
  var weakSetTag = '[object WeakSet]';

  /**
   * Checks if `value` is classified as a `WeakSet` object.
   *
   * @static
   * @memberOf _
   * @since 4.3.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a weak set, else `false`.
   * @example
   *
   * _.isWeakSet(new WeakSet);
   * // => true
   *
   * _.isWeakSet(new Set);
   * // => false
   */
  function isWeakSet(value) {
    return isObjectLike(value) && baseGetTag(value) == weakSetTag;
  }

  export default isWeakSet;
});
//# sourceMappingURL=isWeakSet.js.map