Liferay.Loader.define("frontend-js-tooltip-support-web@3.0.5/index", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-react-web$react', './reducer'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _tooltip = _interopRequireDefault(require("@frontend-taglib-clay$clayui/tooltip"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    var _metalPosition = require("frontend-js-metal-web$metal-position");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reducer = _interopRequireWildcard(require("./reducer"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var ALIGN_POSITIONS = ['top-right', 'top', 'top-left', 'bottom-right', 'bottom', 'bottom-left', 'left', 'right'];
    var SELECTOR_TOOLTIP = '.tooltip[role="tooltip"]';
    var SELECTOR_TRIGGER = "\n\t.lfr-portal-tooltip,\n\t.manage-collaborators-dialog .lexicon-icon[data-title]:not(.lfr-portal-tooltip),\n\t.manage-collaborators-dialog .lexicon-icon[title]:not(.lfr-portal-tooltip),\n\t.manage-collaborators-dialog [data-restore-title],\n\t.management-bar [data-title]:not(.lfr-portal-tooltip),\n\t.management-bar [title]:not(.lfr-portal-tooltip),\n\t.management-bar [data-restore-title],\n\t.preview-toolbar-container [data-title]:not(.lfr-portal-tooltip),\n\t.preview-toolbar-container [title]:not(.lfr-portal-tooltip),\n\t.preview-tooltbar-containter [data-restore-title],\n\t.progress-container[data-title],\n\t.redirect-entries span[data-title],\n\t.source-editor__fixed-text__help[data-title],\n\t.upper-tbar [data-title]:not(.lfr-portal-tooltip),\n\t.upper-tbar [title]:not(.lfr-portal-tooltip),\n\t.upper-tbar [data-restore-title]\n";
    var TRIGGER_HIDE_EVENTS = ['mouseleave', 'mouseup', 'MSPointerUp', 'pointerup', 'touchend'];
    var TRIGGER_SHOW_EVENTS = ['mouseenter', 'mouseup', 'MSPointerDown', 'pointerdown', 'touchstart'];
    var DEFAULT_TOOLTIP_CONTAINER_ID = 'tooltipContainer';

    var getDefaultTooltipContainer = function getDefaultTooltipContainer() {
      var container = document.getElementById(DEFAULT_TOOLTIP_CONTAINER_ID);

      if (!container) {
        container = document.createElement('div');
        container.id = DEFAULT_TOOLTIP_CONTAINER_ID;
        document.body.appendChild(container);
      }

      return container;
    };

    var TooltipProvider = function TooltipProvider() {
      var delay = (0, _frontendJsReactWeb.useTimeout)();

      var _useReducer = (0, _react.useReducer)(_reducer.default, {
        current: _reducer.STATES.IDLE
      }),
          _useReducer2 = _slicedToArray(_useReducer, 2),
          state = _useReducer2[0],
          dispatch = _useReducer2[1];

      var tooltipRef = (0, _react.useRef)(null);

      var _useState = (0, _react.useState)(0),
          _useState2 = _slicedToArray(_useState, 2),
          alignment = _useState2[0],
          setAlignment = _useState2[1];

      (0, _react.useEffect)(function () {
        var dispose;

        if (state.current === _reducer.STATES.WAIT_SHOW) {
          dispose = delay(function () {
            return dispatch({
              type: 'showDelayCompleted'
            });
          }, 500);
        } else if (state.current === _reducer.STATES.WAIT_HIDE) {
          dispose = delay(function () {
            return dispatch({
              type: 'hideDelayCompleted'
            });
          }, 100);
        } else if (state.current === _reducer.STATES.WAIT_RESHOW) {
          dispose = delay(function () {
            return dispatch({
              type: 'showDelayCompleted'
            });
          }, 100);
        }

        return dispose;
      }, [delay, state]);

      var saveTitle = function saveTitle(element) {
        if (element) {
          var title = element.getAttribute('title');

          if (title) {
            element.setAttribute('data-restore-title', title);
            element.removeAttribute('title');
          } else if (element.tagName === 'svg') {
            var titleTag = element.querySelector('title');

            if (titleTag) {
              element.setAttribute('data-restore-title', titleTag.innerHTML);
              titleTag.remove();
            }
          }
        }
      };

      var restoreTitle = function restoreTitle(element) {
        if (element) {
          var title = element.getAttribute('data-restore-title');

          if (title) {
            if (element.tagName === 'svg') {
              var titleTag = document.createElement('title');
              titleTag.innerHTML = title;
              element.appendChild(titleTag);
            } else {
              element.setAttribute('title', title);
            }

            element.removeAttribute('data-restore-title');
          }
        }
      };

      (0, _react.useEffect)(function () {
        var TRIGGER_SHOW_HANDLES = TRIGGER_SHOW_EVENTS.map(function (eventName) {
          return _metalDom.default.delegate(document.body, eventName, SELECTOR_TRIGGER, function (event) {
            saveTitle(event.delegateTarget);
            dispatch({
              target: event.delegateTarget,
              type: 'show'
            });
          });
        });
        var TRIGGER_HIDE_HANDLES = TRIGGER_HIDE_EVENTS.map(function (eventName) {
          return _metalDom.default.delegate(document.body, eventName, SELECTOR_TRIGGER, function () {
            dispatch({
              type: 'hide'
            });
            restoreTitle(state.target);
          });
        });

        var TOOLTIP_ENTER = _metalDom.default.delegate(document.body, 'mouseenter', SELECTOR_TOOLTIP, function () {
          return dispatch({
            target: state.target,
            type: 'show'
          });
        });

        var TOOLTIP_LEAVE = _metalDom.default.delegate(document.body, 'mouseleave', SELECTOR_TOOLTIP, function () {
          return dispatch({
            type: 'hide'
          });
        });

        return function () {
          [TOOLTIP_ENTER, TOOLTIP_LEAVE].concat(_toConsumableArray(TRIGGER_HIDE_HANDLES), _toConsumableArray(TRIGGER_SHOW_HANDLES)).forEach(function (handle) {
            return handle.dispose();
          });
        };
      }, [state]);
      (0, _react.useLayoutEffect)(function () {
        if (state.target && tooltipRef.current) {
          setAlignment(_metalPosition.Align.align(tooltipRef.current, state.target, _metalPosition.Align.BottomCenter));
        }
      }, [state.target]);
      return state.target ? /*#__PURE__*/_react.default.createElement(_tooltip.default, {
        alignPosition: ALIGN_POSITIONS[alignment],
        ref: tooltipRef,
        show: state.current.show
      }, /*#__PURE__*/_react.default.createElement("div", {
        dangerouslySetInnerHTML: {
          __html: state.target.title || state.target.dataset.restoreTitle || state.target.dataset.title
        }
      })) : null;
    };

    var _default = function _default() {
      (0, _frontendJsReactWeb.render)( /*#__PURE__*/_react.default.createElement(TooltipProvider, null), {}, getDefaultTooltipContainer());
    };

    exports.default = _default;
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map