Liferay.Loader.define('frontend-js-tooltip-support-web$dnd-core@11.1.3/dist/esm/actions/dragDrop/endDrag', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { invariant } from '@react-dnd/invariant';
    import { END_DRAG } from './types';
    export function createEndDrag(manager) {
      return function endDrag() {
        var monitor = manager.getMonitor();
        var registry = manager.getRegistry();
        verifyIsDragging(monitor);
        var sourceId = monitor.getSourceId();

        if (sourceId != null) {
          var source = registry.getSource(sourceId, true);
          source.endDrag(monitor, sourceId);
          registry.unpinSource();
        }

        return {
          type: END_DRAG
        };
      };
    }

    function verifyIsDragging(monitor) {
      invariant(monitor.isDragging(), 'Cannot call endDrag while not dragging.');
    }
  }
});
//# sourceMappingURL=endDrag.js.map