/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.top.head.extender.internal.servlet.taglib;

import com.liferay.frontend.js.top.head.extender.TopHeadResources;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.PortalWebResources;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilderFactory;
import com.liferay.portal.url.builder.ComboRequestAbsolutePortalURLBuilder;
import com.liferay.portal.util.JavaScriptBundleUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={DynamicInclude.class})
public class TopHeadDynamicInclude
implements DynamicInclude {
    @Reference
    private AbsolutePortalURLBuilderFactory _absolutePortalURLBuilderFactory;
    private BundleContext _bundleContext;
    @Reference
    private Portal _portal;
    private volatile ResourceURLsHolder _resourceURLsHolder;
    private final Collection<ServiceReference<TopHeadResources>> _topHeadResourcesServiceReferences = new TreeSet<ServiceReference<TopHeadResources>>();
    private ServiceTracker<TopHeadResources, TopHeadResources> _topHeadResourcesServiceTracker;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceURLsHolder resourceURLsHolder = this._getResourceURLsHolder();
        if (themeDisplay.isThemeJsFastLoad()) {
            if (themeDisplay.isThemeJsBarebone()) {
                this._renderBundleComboURLs(httpServletRequest, httpServletResponse, resourceURLsHolder._jsResourceURLs);
            } else {
                this._renderBundleComboURLs(httpServletRequest, httpServletResponse, resourceURLsHolder._allJsResourceURLs);
            }
        } else if (themeDisplay.isThemeJsBarebone()) {
            this._renderBundleURLs(httpServletResponse, resourceURLsHolder._jsResourceURLs);
        } else {
            this._renderBundleURLs(httpServletResponse, resourceURLsHolder._allJsResourceURLs);
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_js.jspf#resources");
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._topHeadResourcesServiceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, TopHeadResources.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<TopHeadResources, TopHeadResources>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TopHeadResources addingService(ServiceReference<TopHeadResources> serviceReference) {
                Collection collection = TopHeadDynamicInclude.this._topHeadResourcesServiceReferences;
                synchronized (collection) {
                    TopHeadDynamicInclude.this._topHeadResourcesServiceReferences.add(serviceReference);
                    TopHeadDynamicInclude.this._resourceURLsHolder = null;
                }
                return (TopHeadResources)bundleContext.getService(serviceReference);
            }

            public void modifiedService(ServiceReference<TopHeadResources> serviceReference, TopHeadResources topHeadResources) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<TopHeadResources> serviceReference, TopHeadResources topHeadResources) {
                Collection collection = TopHeadDynamicInclude.this._topHeadResourcesServiceReferences;
                synchronized (collection) {
                    TopHeadDynamicInclude.this._topHeadResourcesServiceReferences.remove(serviceReference);
                    TopHeadDynamicInclude.this._resourceURLsHolder = null;
                }
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._topHeadResourcesServiceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceURLsHolder _getResourceURLsHolder() {
        ResourceURLsHolder resourceURLsHolder = this._resourceURLsHolder;
        if (resourceURLsHolder != null) {
            return resourceURLsHolder;
        }
        Collection<ServiceReference<TopHeadResources>> collection = this._topHeadResourcesServiceReferences;
        synchronized (collection) {
            if (this._resourceURLsHolder != null) {
                return this._resourceURLsHolder;
            }
            this._resourceURLsHolder = this._rebuild();
            return this._resourceURLsHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceURLsHolder _rebuild() {
        PortalWebResources portalWebResources = PortalWebResourcesUtil.getPortalWebResources((String)"js");
        if (portalWebResources == null) {
            return null;
        }
        ArrayList<String> allJsResourceURLs = new ArrayList<String>();
        ArrayList<String> jsResourceURLs = new ArrayList<String>();
        Collections.addAll(allJsResourceURLs, JavaScriptBundleUtil.getFileNames((String)"javascript.everything.files"));
        Collections.addAll(jsResourceURLs, JavaScriptBundleUtil.getFileNames((String)"javascript.barebone.files"));
        for (ServiceReference<TopHeadResources> topHeadResourcesServiceReference : this._topHeadResourcesServiceReferences) {
            TopHeadResources topHeadResources = (TopHeadResources)this._bundleContext.getService(topHeadResourcesServiceReference);
            try {
                String bundleContextPath = this._portal.getPathContext(topHeadResources.getServletContextPath());
                for (String jsResourcePath : topHeadResources.getJsResourcePaths()) {
                    String url = bundleContextPath + jsResourcePath;
                    allJsResourceURLs.add(url);
                    jsResourceURLs.add(url);
                }
                for (String jsResourcePath : topHeadResources.getAuthenticatedJsResourcePaths()) {
                    allJsResourceURLs.add(bundleContextPath + jsResourcePath);
                }
            }
            finally {
                this._bundleContext.ungetService(topHeadResourcesServiceReference);
            }
        }
        return new ResourceURLsHolder(allJsResourceURLs, jsResourceURLs);
    }

    private void _renderBundleComboURLs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, List<String> urls) throws IOException {
        AbsolutePortalURLBuilder absolutePortalURLBuilder = this._absolutePortalURLBuilderFactory.getAbsolutePortalURLBuilder(httpServletRequest);
        ComboRequestAbsolutePortalURLBuilder comboRequestAbsolutePortalURLBuilder = absolutePortalURLBuilder.forComboRequest();
        comboRequestAbsolutePortalURLBuilder.setTimestamp(PortalWebResourcesUtil.getLastModified((String)"js"));
        String comboURL = comboRequestAbsolutePortalURLBuilder.build();
        PrintWriter printWriter = httpServletResponse.getWriter();
        StringBundler sb = new StringBundler();
        for (String url : urls) {
            if (sb.length() + url.length() + 1 >= 2000) {
                this._renderScriptURL(printWriter, sb.toString());
                sb = new StringBundler();
            }
            if (sb.length() == 0) {
                sb.append(comboURL);
            }
            sb.append("&");
            sb.append(url);
        }
        if (sb.length() > 0) {
            this._renderScriptURL(printWriter, sb.toString());
        }
    }

    private void _renderBundleURLs(HttpServletResponse httpServletResponse, List<String> urls) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        for (String url : urls) {
            this._renderScriptURL(printWriter, url);
        }
    }

    private void _renderScriptURL(PrintWriter printWriter, String url) {
        printWriter.print("<script data-senna-track=\"permanent\" src=\"");
        printWriter.print(url);
        printWriter.println("\" type=\"text/javascript\"></script>");
    }

    private static class ResourceURLsHolder {
        private final List<String> _allJsResourceURLs;
        private final List<String> _jsResourceURLs;

        private ResourceURLsHolder(List<String> allJsResourceURLs, List<String> jsResourceURLs) {
            this._allJsResourceURLs = allJsResourceURLs;
            this._jsResourceURLs = jsResourceURLs;
        }
    }
}

