Liferay.Loader.define("frontend-js-web@4.0.46/liferay/DynamicSelect", ['module', 'exports', 'require', './util/toggle_disabled'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _toggle_disabled = _interopRequireDefault(require("./util/toggle_disabled"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function sortByValue(a, b) {
      var position = a.indexOf('">');
      var nameA = a.substring(position);
      position = b.indexOf('">');
      var nameB = b.substring(position);

      if (nameA < nameB) {
        return -1;
      } else if (nameA > nameB) {
        return 1;
      } else {
        return 0;
      }
    }
    /**
     * For backwards compatibility, same semantics as YUI's `Array.test()`.
     *
     * @see https://github.com/yui/yui3/blob/25264e3629b1c07fb779d203c4a25c0879ec862c/src/yui/js/yui-array.js#L271-L306
     */

    function isArrayLike(value) {
      if (Array.isArray(value)) {
        return true;
      }

      return !!(value && _typeof(value) === 'object' && typeof value.length === 'number' && !value.tagName && !value.scrollTo && !value.document);
    }

    function toArray(value) {
      return isArrayLike(value) ? Array.from(value) : [value];
    }

    function updateSelect(array, index, list) {
      var options = array[index];
      var select = document.getElementById(options.select);

      if (!select) {
        return;
      }

      var selectVal = toArray(options.selectVal);
      var selectOptions = [];

      if (options.selectNullable !== false) {
        selectOptions.push('<option selected value="0"></option>');
      }

      list.forEach(function (item) {
        var key = item[options.selectId];
        var value = item[options.selectDesc];
        var selected = '';

        if (selectVal.indexOf(key) > -1) {
          selected = 'selected="selected"';
        }

        selectOptions.push("<option ".concat(selected, " value=\"").concat(key, "\">").concat(value, "</option>"));
      });

      if (options.selectSort) {
        selectOptions.sort(sortByValue);
      }

      while (select.lastChild) {
        select.removeChild(select.lastChild);
      }

      select.innerHTML = selectOptions.join('');

      if (options.selectDisableOnEmpty) {
        (0, _toggle_disabled.default)(select, !list.length);
      }
    }

    function callSelectData(array, index) {
      if (index + 1 < array.length) {
        var currentSelect = document.getElementById(array[index].select);
        var nextSelectData = array[index + 1].selectData;
        nextSelectData(function (list) {
          updateSelect(array, index + 1, list);
        }, currentSelect && currentSelect.value);
      }
    }

    function process(array) {
      array.forEach(function (item, index) {
        var id = item.select;
        var select = document.getElementById(id);
        var selectData = item.selectData;

        if (select) {
          select.setAttribute('data-componentType', 'dynamic_select');
          var prevSelectVal;

          if (index > 0) {
            prevSelectVal = array[index - 1].selectVal;
          }

          selectData(function (list) {
            updateSelect(array, index, list);
          }, prevSelectVal);

          if (!select.getAttribute('name')) {
            select.setAttribute('name', id);
          }

          select.addEventListener('change', function () {
            callSelectData(array, index);
          });
        }
      });
    }
    /**
     * Ideally would be a function, but it is a class for backwards compatibility.
     */

    var DynamicSelect = function DynamicSelect(array) {
      _classCallCheck(this, DynamicSelect);

      process(array);
    };

    exports.default = DynamicSelect;
    //# sourceMappingURL=DynamicSelect.js.map
  }
});
//# sourceMappingURL=DynamicSelect.js.map