Liferay.Loader.define("frontend-js-web@4.0.46/liferay/modal/Modal", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/loading-indicator', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './Modal.scss', '../util/navigate.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.openSelectionModal = exports.openPortletWindow = exports.openPortletModal = exports.openModal = exports.Modal = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    require("./Modal.scss");

    var _navigate = _interopRequireDefault(require("../util/navigate.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var Modal = function Modal(_ref) {
      var bodyHTML = _ref.bodyHTML,
          buttons = _ref.buttons,
          customEvents = _ref.customEvents,
          headerHTML = _ref.headerHTML,
          height = _ref.height,
          id = _ref.id,
          iframeBodyCssClass = _ref.iframeBodyCssClass,
          _ref$iframeProps = _ref.iframeProps,
          iframeProps = _ref$iframeProps === void 0 ? {} : _ref$iframeProps,
          onClose = _ref.onClose,
          onOpen = _ref.onOpen,
          size = _ref.size,
          title = _ref.title,
          url = _ref.url,
          zIndex = _ref.zIndex;

      var _useState = (0, _react.useState)(true),
          _useState2 = _slicedToArray(_useState, 2),
          loading = _useState2[0],
          setLoading = _useState2[1];

      var _useState3 = (0, _react.useState)(true),
          _useState4 = _slicedToArray(_useState3, 2),
          visible = _useState4[0],
          setVisible = _useState4[1];

      var eventHandlersRef = (0, _react.useRef)([]);
      var processClose = (0, _react.useCallback)(function () {
        setVisible(false);
        document.body.classList.remove('modal-open');
        var eventHandlers = eventHandlersRef.current;
        eventHandlers.forEach(function (eventHandler) {
          eventHandler.detach();
        });
        eventHandlers.splice(0, eventHandlers.length);

        if (onClose) {
          onClose();
        }
      }, [eventHandlersRef, onClose]);

      var _useModal = (0, _modal.useModal)({
        onClose: function onClose() {
          return processClose();
        }
      }),
          observer = _useModal.observer;

      var onButtonClick = function onButtonClick(_ref2) {
        var formId = _ref2.formId,
            onClick = _ref2.onClick,
            type = _ref2.type;

        if (type === 'cancel') {
          processClose();
        } else if (url && type === 'submit') {
          var iframe = document.querySelector('.liferay-modal iframe');

          if (iframe) {
            var iframeDocument = iframe.contentWindow.document;
            var forms = iframeDocument.querySelectorAll('form');

            if (formId) {
              var form = iframeDocument.getElementById(formId);

              if (form) {
                form.submit();
              }
            } else if (forms.length >= 1) {
              forms[0].submit();
            }
          }
        }

        if (onClick) {
          onClick({
            processClose: processClose
          });
        }
      };

      (0, _react.useEffect)(function () {
        var eventHandlers = eventHandlersRef.current;

        if (customEvents) {
          customEvents.forEach(function (customEvent) {
            if (customEvent.name && customEvent.onEvent) {
              var eventHandler = Liferay.on(customEvent.name, function (event) {
                customEvent.onEvent(event);
              });
              eventHandlers.push(eventHandler);
            }
          });
        }

        var closeEventHandler = Liferay.on('closeModal', function (event) {
          if (event.id && id && event.id !== id) {
            return;
          }

          processClose();

          if (event.redirect) {
            (0, _navigate.default)(event.redirect);
          }
        });
        eventHandlers.push(closeEventHandler);
        return function () {
          eventHandlers.forEach(function (eventHandler) {
            eventHandler.detach();
          });
          eventHandlers.splice(0, eventHandlers.length);
        };
      }, [customEvents, eventHandlersRef, id, onClose, onOpen, processClose]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visible && /*#__PURE__*/_react.default.createElement(_modal.default, {
          className: "liferay-modal",
          id: id,
          observer: observer,
          size: url && !size ? 'full-screen' : size,
          zIndex: zIndex
        }, /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, headerHTML ? /*#__PURE__*/_react.default.createElement("div", {
          dangerouslySetInnerHTML: {
            __html: headerHTML
          }
        }) : title), /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('modal-body', {
            'modal-body-iframe': url
          }),
          style: {
            height: height
          }
        }, url ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading && /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, null), /*#__PURE__*/_react.default.createElement(Iframe, {
          iframeBodyCssClass: iframeBodyCssClass,
          iframeProps: _objectSpread({
            id: id && "".concat(id, "_iframe_")
          }, iframeProps),
          onOpen: onOpen,
          processClose: processClose,
          title: title,
          updateLoading: function updateLoading(loading) {
            setLoading(loading);
          },
          url: url
        })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, bodyHTML && /*#__PURE__*/_react.default.createElement(function Body(_ref3) {
          var html = _ref3.html;
          var bodyRef = (0, _react.useRef)();
          (0, _react.useEffect)(function () {
            var fragment = document.createRange().createContextualFragment(html);
            bodyRef.current.innerHTML = '';
            bodyRef.current.appendChild(fragment);

            if (onOpen) {
              onOpen({
                container: fragment,
                processClose: processClose
              });
            }
          }, [html]);
          return (/*#__PURE__*/_react.default.createElement("div", {
              className: "liferay-modal-body",
              ref: bodyRef
            })
          );
        }, {
          html: bodyHTML
        }))), buttons && /*#__PURE__*/_react.default.createElement(_modal.default.Footer, {
          last: /*#__PURE__*/_react.default.createElement(_button.default.Group, {
            spaced: true
          }, buttons.map(function (button, index) {
            return (/*#__PURE__*/_react.default.createElement(_button.default, {
                displayType: button.displayType,
                id: button.id,
                key: index,
                onClick: function onClick() {
                  onButtonClick(button);
                },
                type: button.type === 'cancel' ? 'button' : button.type
              }, button.label)
            );
          }))
        })))
      );
    };

    exports.Modal = Modal;

    var openModal = function openModal(props) {
      // Mount in detached node; Clay will take care of appending to `document.body`.
      // See: https://github.com/liferay/clay/blob/master/packages/clay-shared/src/Portal.tsx


      (0, _frontendJsReactWeb.render)(Modal, props, document.createElement('div'));
    };

    exports.openModal = openModal;

    var openPortletModal = function openPortletModal(_ref4) {
      var iframeBodyCssClass = _ref4.iframeBodyCssClass,
          onClose = _ref4.onClose,
          portletSelector = _ref4.portletSelector,
          subTitle = _ref4.subTitle,
          title = _ref4.title,
          url = _ref4.url;
      var portlet = document.querySelector(portletSelector);

      if (portlet && url) {
        var titleElement = portlet.querySelector('.portlet-title') || portlet.querySelector('.portlet-title-default');

        if (titleElement) {
          if (portlet.querySelector('#cpPortletTitle')) {
            var titleTextElement = titleElement.querySelector('.portlet-title-text');

            if (titleTextElement) {
              title = "".concat(titleTextElement.outerHTML, " - ").concat(title);
            }
          } else {
            title = "".concat(titleElement.textContent, " - ").concat(title);
          }
        }

        var headerHTML;

        if (subTitle) {
          headerHTML = "".concat(title, "<div class=\"portlet-configuration-subtitle small\"><span class=\"portlet-configuration-subtitle-text\">").concat(subTitle, "</span></div>");
        }

        openModal({
          headerHTML: headerHTML,
          iframeBodyCssClass: iframeBodyCssClass,
          onClose: onClose,
          title: title,
          url: url
        });
      }
    };
    /**
     * A utility with API that matches Liferay.Portlet.openWindow. The purpose of
     * this utility is backwards compatibility.
     * @deprecated As of Athanasius (7.3.x), replaced by Liferay.Portlet.openModal
     */

    exports.openPortletModal = openPortletModal;

    var openPortletWindow = function openPortletWindow(_ref5) {
      var bodyCssClass = _ref5.bodyCssClass,
          portlet = _ref5.portlet,
          uri = _ref5.uri,
          otherProps = _objectWithoutProperties(_ref5, ["bodyCssClass", "portlet", "uri"]);

      openPortletModal(_objectSpread({
        iframeBodyCssClass: bodyCssClass,
        portletSelector: portlet,
        url: uri
      }, otherProps));
    };

    exports.openPortletWindow = openPortletWindow;

    var openSelectionModal = function openSelectionModal(_ref6) {
      var _ref6$buttonAddLabel = _ref6.buttonAddLabel,
          buttonAddLabel = _ref6$buttonAddLabel === void 0 ? Liferay.Language.get('add') : _ref6$buttonAddLabel,
          _ref6$buttonCancelLab = _ref6.buttonCancelLabel,
          buttonCancelLabel = _ref6$buttonCancelLab === void 0 ? Liferay.Language.get('cancel') : _ref6$buttonCancelLab,
          _ref6$customSelectEve = _ref6.customSelectEvent,
          customSelectEvent = _ref6$customSelectEve === void 0 ? false : _ref6$customSelectEve,
          height = _ref6.height,
          id = _ref6.id,
          _ref6$multiple = _ref6.multiple,
          multiple = _ref6$multiple === void 0 ? false : _ref6$multiple,
          _onClose = _ref6.onClose,
          onSelect = _ref6.onSelect,
          selectEventName = _ref6.selectEventName,
          selectedData = _ref6.selectedData,
          size = _ref6.size,
          title = _ref6.title,
          url = _ref6.url,
          zIndex = _ref6.zIndex;
      var eventHandlers = [];
      var iframeWindowObj;
      var processCloseFn;
      var selectedItem;

      var select = function select() {
        if (multiple && !selectedItem) {
          var searchContainer = iframeWindowObj.document.querySelector('.searchcontainer');

          if (searchContainer) {
            iframeWindowObj.Liferay.componentReady(searchContainer.id).then(function (searchContainer) {
              var allSelectedElements = searchContainer.select.getAllSelectedElements();
              var allSelectedNodes = allSelectedElements.getDOMNodes();
              onSelect(allSelectedNodes.map(function (node) {
                var item = {};

                if (node.value) {
                  item.value = node.value;
                }

                var row = node.closest('tr, li');

                if (row && Object.keys(row.dataset).length) {
                  item = _objectSpread(_objectSpread({}, item), row.dataset);
                }

                return item;
              }));
              processCloseFn();
            });
          }
        } else {
          onSelect(selectedItem);
          processCloseFn();
        }
      };

      openModal({
        buttons: multiple ? [{
          displayType: 'secondary',
          label: buttonCancelLabel,
          type: 'cancel'
        }, {
          label: buttonAddLabel,
          onClick: select
        }] : null,
        height: height,
        id: id || selectEventName,
        onClose: function onClose() {
          eventHandlers.forEach(function (eventHandler) {
            eventHandler.detach();
          });
          eventHandlers.splice(0, eventHandlers.length);

          if (_onClose) {
            _onClose();
          }
        },
        onOpen: function onOpen(_ref7) {
          var iframeWindow = _ref7.iframeWindow,
              processClose = _ref7.processClose;
          iframeWindowObj = iframeWindow;
          processCloseFn = processClose;
          var iframeBody = iframeWindow.document.body;
          var itemElements = iframeBody.querySelectorAll('.selector-button');

          if (selectedData) {
            var selectedDataSet = new Set(selectedData);
            itemElements.forEach(function (itemElement) {
              var itemId = itemElement.dataset.entityid || itemElement.dataset.entityname;

              if (selectedDataSet.has(itemId)) {
                itemElement.disabled = true;
              }
            });
          }

          if (selectEventName) {
            var selectEventHandler = Liferay.on(selectEventName, function (event) {
              selectedItem = event.data || event;

              if (!multiple) {
                select();
              }
            });
            eventHandlers.push(selectEventHandler);

            if (!customSelectEvent) {
              iframeBody.addEventListener('click', function (event) {
                var _event$target;

                var delegateTarget = (_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.closest('.selector-button');

                if (delegateTarget) {
                  Liferay.fire(selectEventName, delegateTarget.dataset);
                }
              });
            }
          }
        },
        size: size,
        title: title,
        url: url,
        zIndex: zIndex
      });
    };

    exports.openSelectionModal = openSelectionModal;
    var CSS_CLASS_IFRAME_BODY = 'dialog-iframe-popup';

    var Iframe = /*#__PURE__*/function (_React$Component) {
      _inherits(Iframe, _React$Component);

      function Iframe(props) {
        var _this;

        _classCallCheck(this, Iframe);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(Iframe).call(this, props));

        _defineProperty(_assertThisInitialized(_this), "onLoadHandler", function () {
          var iframeWindow = _this.iframeRef.current.contentWindow;
          _this.delegateHandler = _metalDom.default.delegate(iframeWindow.document, 'click', '.btn-cancel,.lfr-hide-dialog', function () {
            return _this.props.processClose();
          });
          iframeWindow.document.body.classList.add(CSS_CLASS_IFRAME_BODY);

          if (iframeWindow.Liferay.SPA) {
            _this.beforeScreenFlipHandler = iframeWindow.Liferay.on('beforeScreenFlip', function () {
              iframeWindow.document.body.classList.add(CSS_CLASS_IFRAME_BODY);
            });
          }

          _this.props.updateLoading(false);

          iframeWindow.onunload = function () {
            _this.props.updateLoading(true);
          };

          Liferay.fire('modalIframeLoaded', {
            src: _this.state.src
          });

          if (_this.props.onOpen) {
            _this.props.onOpen({
              iframeWindow: iframeWindow,
              processClose: _this.props.processClose
            });
          }
        });

        _this.iframeRef = /*#__PURE__*/_react.default.createRef();
        var iframeURL = new URL(props.url);
        var namespace = iframeURL.searchParams.get('p_p_id');
        var bodyCssClass = CSS_CLASS_IFRAME_BODY;

        if (props.iframeBodyCssClass) {
          bodyCssClass = "".concat(bodyCssClass, " ").concat(props.iframeBodyCssClass);
        }

        iframeURL.searchParams.set("_".concat(namespace, "_bodyCssClass"), bodyCssClass);
        _this.state = {
          src: iframeURL.toString()
        };
        return _this;
      }

      _createClass(Iframe, [{
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          if (this.beforeScreenFlipHandler) {
            Liferay.detach(this.beforeScreenFlipHandler);
          }

          if (this.delegateHandler) {
            this.delegateHandler.removeListener();
          }
        }
      }, {
        key: "render",
        value: function render() {
          return (/*#__PURE__*/_react.default.createElement("iframe", _extends({}, this.props.iframeProps, {
              onLoad: this.onLoadHandler,
              ref: this.iframeRef,
              src: this.state.src,
              title: this.props.title
            }))
          );
        }
      }]);

      return Iframe;
    }(_react.default.Component);
    //# sourceMappingURL=Modal.js.map
  }
});
//# sourceMappingURL=Modal.js.map