Liferay.Loader.define("frontend-js-web@4.0.46/liferay/portlet/portlet.es", ['module', 'exports', 'require', '../util/fetch.es', '../util/form/object_to_form_data.es', '../util/get_portlet_id', '../util/portlet_url/create_portlet_url.es', './register.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.minimizePortlet = minimizePortlet;
    exports.default = void 0;

    var _fetch = _interopRequireDefault(require("../util/fetch.es"));

    var _object_to_form_data = _interopRequireDefault(require("../util/form/object_to_form_data.es"));

    var _get_portlet_id = _interopRequireDefault(require("../util/get_portlet_id"));

    var _create_portlet_url = _interopRequireDefault(require("../util/portlet_url/create_portlet_url.es"));

    var _register = _interopRequireDefault(require("./register.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Minimizes portlet
     * @param {String} portletSelector Portlet container selector
     * @param {HTMLElement} trigger Trigger element
     * @param {Object} options Additional options
     */
    function minimizePortlet(portletSelector, trigger, options) {
      options = _objectSpread({
        doAsUserId: themeDisplay.getDoAsUserIdEncoded(),
        plid: themeDisplay.getPlid()
      }, options);
      var portlet = document.querySelector(portletSelector);

      if (portlet) {
        var content = portlet.querySelector('.portlet-content-container');

        if (content) {
          var minimized = content.classList.contains('hide');

          if (minimized) {
            content.classList.remove('hide');
            portlet.classList.remove('portlet-minimized');
          } else {
            content.classList.add('hide');
            portlet.classList.add('portlet-minimized');
          }

          if (trigger) {
            var title = minimized ? Liferay.Language.get('minimize') : Liferay.Language.get('restore');
            trigger.setAttribute('alt', title);
            trigger.setAttribute('title', title);
            var triggerText = trigger.querySelector('.taglib-text-icon');

            if (triggerText) {
              triggerText.innerHTML = title;
            }

            var icon = trigger.querySelector('i');

            if (icon) {
              icon.classList.remove('icon-minus', 'icon-resize-vertical');

              if (minimized) {
                icon.classList.add('icon-minus');
                icon.classList.remove('icon-resize-vertical');
              } else {
                icon.classList.add('icon-resize-vertical');
                icon.classList.remove('icon-minus');
              }
            }
          }

          var portletId = (0, _get_portlet_id.default)(portlet.id);
          var formData = (0, _object_to_form_data.default)({
            cmd: 'minimize',
            doAsUserId: options.doAsUserId,
            p_auth: Liferay.authToken,
            p_l_id: options.plid,
            p_p_id: portletId,
            p_p_restore: minimized,
            p_v_l_s_g_id: themeDisplay.getSiteGroupId()
          });
          (0, _fetch.default)(themeDisplay.getPathMain() + '/portal/update_layout', {
            body: formData,
            method: 'POST'
          }).then(function (response) {
            if (response.ok && minimized) {
              var params = {
                doAsUserId: options.doAsUserId,
                p_l_id: options.plid,
                p_p_boundary: false,
                p_p_id: portletId,
                p_p_isolated: true
              };
              (0, _fetch.default)((0, _create_portlet_url.default)(themeDisplay.getPathMain() + '/portal/render_portlet', params)).then(function (response) {
                return response.text();
              }).then(function (response) {
                var range = document.createRange();
                range.selectNode(portlet);
                portlet.innerHTML = '';
                var fragment = range.createContextualFragment(response);
                portlet.appendChild(fragment);
              }).catch(function (error) {});
            }
          }).catch(function (error) {});
        }
      }
    }

    var _default = {
      register: _register.default
    };
    exports.default = _default;
    //# sourceMappingURL=portlet.es.js.map
  }
});
//# sourceMappingURL=portlet.es.js.map