Liferay.Loader.define("frontend-js-web@4.0.46/liferay/side_navigation.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _metalEvents = _interopRequireDefault(require("frontend-js-metal-web$metal-events"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    /**
     * Options
     *
     * @property {String|Number}  breakpoint   The window width that defines the desktop size.
     * @property {String}         content      The class or ID of the content container.
     * @property {String}         container    The class or ID of the sidenav container.
     * @property {String|Number}  gutter       The space between the sidenav-slider and the sidenav-content.
     * @property {String}         navigation   The class or ID of the navigation container.
     * @property {String}         position     The position of the sidenav-slider. Possible values: left, right
     * @property {String}         type         The type of sidenav in desktop. Possible values: relative, fixed, fixed-push
     * @property {String}         typeMobile   The type of sidenav in mobile. Possible values: relative, fixed, fixed-push
     * @property {String|Object}  url          The URL to fetch the content to inject into .sidebar-body
     * @property {String|Number}  width        The width of the side navigation.
     */
    var DEFAULTS = {
      breakpoint: 768,
      content: '.sidenav-content',
      gutter: '0px',
      loadingIndicatorTPL: '<div class="loading-animation loading-animation-md"></div>',
      navigation: '.sidenav-menu-slider',
      position: 'left',
      type: 'relative',
      typeMobile: 'relative',
      url: null,
      width: '225px'
    };
    /**
     * Map from toggler DOM nodes to sidenav instances.
     */

    var INSTANCE_MAP = new WeakMap();
    /**
     * Utility function that strips off a possible jQuery and Metal
     * component wrappers from a DOM element.
     */

    function getElement(element) {
      // Remove jQuery wrapper, if any.
      if (element && element.jquery) {
        if (element.length > 1) {
          throw new Error("getElement(): Expected at most one element, got ".concat(element.length));
        }

        element = element.get(0);
      } // Remove Metal wrapper, if any.


      if (element && !(element instanceof HTMLElement)) {
        element = element.element;
      }

      return element;
    }

    function getInstance(element) {
      element = getElement(element);
      var instance = INSTANCE_MAP.get(element);
      return instance;
    }
    /**
     * A list of attributes that can contribute to the "identity" of an element, for
     * the purposes of delegated event handling.
     */

    var IDENTITY_ATTRIBUTES = [/^aria-/, /^data-/, /^type$/];
    /**
     * Returns a unique selector for the supplied element. Ideally we'd just use
     * the "id" attribute (assigning one if necessary), but the use of Metal
     * components means that any "id" we assign will be blown away on the next state
     * change.
     */

    function getUniqueSelector(element) {
      element = getElement(element);

      if (element.id) {
        return "#".concat(element.id);
      }

      var ancestorWithId = element.parentNode;

      while (ancestorWithId) {
        if (ancestorWithId.id) {
          break;
        }

        ancestorWithId = ancestorWithId.parentNode;
      }

      var attributes = Array.from(element.attributes).map(function (_ref) {
        var name = _ref.name,
            value = _ref.value;
        var isIdentifying = IDENTITY_ATTRIBUTES.some(function (regExp) {
          return regExp.test(name);
        });
        return isIdentifying ? "[".concat(name, "=").concat(JSON.stringify(value), "]") : null;
      }).filter(Boolean).sort();
      return [ancestorWithId ? "#".concat(ancestorWithId.id, " ") : '', element.tagName.toLowerCase()].concat(_toConsumableArray(attributes)).join('');
    }

    function addClass(element, className) {
      setClasses(element, _defineProperty({}, className, true));
    }

    function removeClass(element, className) {
      setClasses(element, _defineProperty({}, className, false));
    }

    function setClasses(element, classes) {
      element = getElement(element);

      if (element) {
        // One at a time because IE 11: https://caniuse.com/#feat=classlist
        Object.entries(classes).forEach(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 2),
              className = _ref3[0],
              present = _ref3[1];

          // Some callers use multiple space-separated classNames for
          // `openClass`/`data-open-class`. (Looking at you,
          // product-navigation-simulation-web...)
          className.split(/\s+/).forEach(function (name) {
            if (present) {
              element.classList.add(name);
            } else {
              element.classList.remove(name);
            }
          });
        });
      }
    }

    function hasClass(element, className) {
      element = getElement(element); // Again, product-navigation-simulation-web passes multiple classNames.

      return className.split(/\s+/).every(function (name) {
        return element.classList.contains(name);
      });
    }

    function setStyles(element, styles) {
      element = getElement(element);

      if (element) {
        Object.entries(styles).forEach(function (_ref4) {
          var _ref5 = _slicedToArray(_ref4, 2),
              property = _ref5[0],
              value = _ref5[1];

          element.style[property] = value;
        });
      }
    }
    /**
     * For compatibility with jQuery, which will treat "100" as "100px".
     */

    function px(dimension) {
      if (typeof dimension === 'number') {
        return dimension + 'px';
      } else if (typeof dimension === 'string' && dimension.match(/^\s*\d+\s*$/)) {
        return dimension.trim() + 'px';
      } else {
        return dimension;
      }
    }
    /**
     * Replacement for jQuery's `offset().left`.
     *
     * @see: https://github.com/jquery/jquery/blob/438b1a3e8a52/src/offset.js#L94-L100
     */

    function offsetLeft(element) {
      var elementLeft = element.getBoundingClientRect().left;
      var documentOffset = element.ownerDocument.defaultView.pageOffsetX || 0;
      return elementLeft + documentOffset;
    }
    /**
     * Keys are event names (eg. "click").
     * Values are objects mapping selectors to EventEmitters.
     */

    var eventNamesToSelectors = {};

    function handleEvent(eventName, event) {
      Object.keys(eventNamesToSelectors[eventName]).forEach(function (selector) {
        var matches = false;
        var target = event.target;

        while (target) {
          // In IE11 SVG elements have no `parentElement`, only a
          // `parentNode`, so we have to search up the DOM using
          // the latter. This in turn requires us to check for the
          // existence of `target.matches` before using it.
          //
          // See: https://stackoverflow.com/a/36270354/2103996
          matches = target.matches && target.matches(selector);

          if (matches) {
            break;
          }

          target = target.parentNode;
        }

        if (matches) {
          var emitter = eventNamesToSelectors[eventName][selector];
          emitter.emit('click', event);
        }
      });
    }
    /**
     * Creates a delegated event listener for `eventName` events on
     * `elementOrSelector`.
     */

    function subscribe(elementOrSelector, eventName, handler) {
      if (elementOrSelector) {
        // Add only one listener per `eventName`.
        if (!eventNamesToSelectors[eventName]) {
          eventNamesToSelectors[eventName] = {};
          document.body.addEventListener(eventName, function (event) {
            return handleEvent(eventName, event);
          });
        }

        var emitters = eventNamesToSelectors[eventName];
        var selector = typeof elementOrSelector === 'string' ? elementOrSelector : getUniqueSelector(elementOrSelector);

        if (!emitters[selector]) {
          emitters[selector] = new _metalEvents.default();
        }

        var emitter = emitters[selector];
        var subscription = emitter.on(eventName, function (event) {
          if (!event.defaultPrevented) {
            handler(event);
          }
        });
        return {
          dispose: function dispose() {
            subscription.dispose();
          }
        };
      }

      return null;
    }

    function toInt(str) {
      return parseInt(str, 10) || 0;
    }

    function SideNavigation(toggler, options) {
      toggler = getElement(toggler);
      this.init(toggler, options);
    }

    SideNavigation.TRANSITION_DURATION = 500;
    SideNavigation.prototype = {
      _bindUI: function _bindUI() {
        var instance = this;

        instance._subscribeClickTrigger();

        instance._subscribeClickSidenavClose();
      },
      _emit: function _emit(event) {
        this._emitter.emit(event, this);
      },
      _getSidenavWidth: function _getSidenavWidth() {
        var instance = this;
        var options = instance.options;
        var widthOriginal = options.widthOriginal;
        var width = widthOriginal;
        var winWidth = window.innerWidth;

        if (winWidth < widthOriginal + 40) {
          width = winWidth - 40;
        }

        return width;
      },
      _getSimpleSidenavType: function _getSimpleSidenavType() {
        var instance = this;
        var options = instance.options;

        var desktop = instance._isDesktop();

        var type = options.type;
        var typeMobile = options.typeMobile;

        if (desktop && type === 'fixed-push') {
          return 'desktop-fixed-push';
        } else if (!desktop && typeMobile === 'fixed-push') {
          return 'mobile-fixed-push';
        }

        return 'fixed';
      },
      _isDesktop: function _isDesktop() {
        return window.innerWidth >= this.options.breakpoint;
      },
      _isSidenavRight: function _isSidenavRight() {
        var instance = this;
        var options = instance.options;
        var container = document.querySelector(options.container);
        var isSidenavRight = hasClass(container, 'sidenav-right');
        return isSidenavRight;
      },
      _isSimpleSidenavClosed: function _isSimpleSidenavClosed() {
        var instance = this;
        var options = instance.options;
        var openClass = options.openClass;
        var container = document.querySelector(options.container);
        return !hasClass(container, openClass);
      },
      _loadUrl: function _loadUrl(element, url) {
        var instance = this;
        var sidebar = element.querySelector('.sidebar-body');

        if (!instance._fetchPromise && sidebar) {
          while (sidebar.firstChild) {
            sidebar.removeChild(sidebar.firstChild);
          }

          var loading = document.createElement('div');
          addClass(loading, 'sidenav-loading');
          loading.innerHTML = instance.options.loadingIndicatorTPL;
          sidebar.appendChild(loading);
          instance._fetchPromise = Liferay.Util.fetch(url);

          instance._fetchPromise.then(function (response) {
            if (!response.ok) {
              throw new Error("Failed to fetch ".concat(url));
            }

            return response.text();
          }).then(function (text) {
            var range = document.createRange();
            range.selectNode(sidebar); // Unlike `.innerHTML`, this will eval scripts.

            var fragment = range.createContextualFragment(text);
            sidebar.removeChild(loading);
            sidebar.appendChild(fragment);
            instance.setHeight();
          }).catch(function (err) {
            console.error(err);
          });
        }
      },
      _renderNav: function _renderNav() {
        var instance = this;
        var options = instance.options;
        var container = document.querySelector(options.container);
        var navigation = container.querySelector(options.navigation);
        var menu = navigation.querySelector('.sidenav-menu');
        var closed = hasClass(container, 'closed');

        var sidenavRight = instance._isSidenavRight();

        var width = instance._getSidenavWidth();

        if (closed) {
          setStyles(menu, {
            width: px(width)
          });

          if (sidenavRight) {
            var positionDirection = options.rtl ? 'left' : 'right';
            setStyles(menu, _defineProperty({}, positionDirection, px(width)));
          }
        } else {
          instance.showSidenav();
          instance.setHeight();
        }
      },
      _renderUI: function _renderUI() {
        var instance = this;
        var options = instance.options;
        var container = document.querySelector(options.container);
        var toggler = instance.toggler;
        var mobile = instance.mobile;
        var type = mobile ? options.typeMobile : options.type;

        if (!instance.useDataAttribute) {
          if (mobile) {
            setClasses(container, {
              closed: true,
              open: false
            });
            setClasses(toggler, {
              active: false,
              open: false
            });
          }

          if (options.position === 'right') {
            addClass(container, 'sidenav-right');
          }

          if (type !== 'relative') {
            addClass(container, 'sidenav-fixed');
          }

          instance._renderNav();
        } // Force Reflow for IE11 Browser Bug


        setStyles(container, {
          display: ''
        });
      },
      _subscribeClickSidenavClose: function _subscribeClickSidenavClose() {
        var instance = this;
        var options = instance.options;
        var containerSelector = options.container;

        if (!instance._sidenavCloseSubscription) {
          var closeButtonSelector = "".concat(containerSelector, " .sidenav-close");
          instance._sidenavCloseSubscription = subscribe(closeButtonSelector, 'click', function handleSidenavClose(event) {
            event.preventDefault();
            instance.toggle();
          });
        }
      },
      _subscribeClickTrigger: function _subscribeClickTrigger() {
        var instance = this;

        if (!instance._togglerSubscription) {
          var toggler = instance.toggler;
          instance._togglerSubscription = subscribe(toggler, 'click', function handleTogglerClick(event) {
            instance.toggle();
            event.preventDefault();
          });
        }
      },
      _subscribeSidenavTransitionEnd: function _subscribeSidenavTransitionEnd(element, fn) {
        setTimeout(function () {
          removeClass(element, 'sidenav-transition');
          fn();
        }, SideNavigation.TRANSITION_DURATION);
      },
      clearHeight: function clearHeight() {
        var instance = this;
        var options = instance.options;
        var container = document.querySelector(options.container);

        if (container) {
          var content = container.querySelector(options.content);
          var navigation = container.querySelector(options.navigation);
          var menu = container.querySelector('.sidenav-menu');
          [content, navigation, menu].forEach(function (element) {
            setStyles(element, {
              height: '',
              'min-height': ''
            });
          });
        }
      },
      destroy: function destroy() {
        var instance = this;

        if (instance._sidenavCloseSubscription) {
          instance._sidenavCloseSubscription.dispose();

          instance._sidenavCloseSubscription = null;
        }

        if (instance._togglerSubscription) {
          instance._togglerSubscription.dispose();

          instance._togglerSubscription = null;
        }

        INSTANCE_MAP.delete(instance.toggler);
      },
      hide: function hide() {
        var instance = this;

        if (instance.useDataAttribute) {
          instance.hideSimpleSidenav();
        } else {
          instance.toggleNavigation(false);
        }
      },
      hideSidenav: function hideSidenav() {
        var instance = this;
        var options = instance.options;
        var container = document.querySelector(options.container);

        if (container) {
          var _setStyles2;

          var content = container.querySelector(options.content);
          var navigation = container.querySelector(options.navigation);
          var menu = navigation.querySelector('.sidenav-menu');

          var sidenavRight = instance._isSidenavRight();

          var positionDirection = options.rtl ? 'right' : 'left';

          if (sidenavRight) {
            positionDirection = options.rtl ? 'left' : 'right';
          }

          var paddingDirection = 'padding-' + positionDirection;
          setStyles(content, (_setStyles2 = {}, _defineProperty(_setStyles2, paddingDirection, ''), _defineProperty(_setStyles2, positionDirection, ''), _setStyles2));
          setStyles(navigation, {
            width: ''
          });

          if (sidenavRight) {
            setStyles(menu, _defineProperty({}, positionDirection, px(instance._getSidenavWidth())));
          }
        }
      },
      hideSimpleSidenav: function hideSimpleSidenav() {
        var instance = this;
        var options = instance.options;

        var simpleSidenavClosed = instance._isSimpleSidenavClosed();

        if (!simpleSidenavClosed) {
          var _setClasses4;

          var content = document.querySelector(options.content);
          var container = document.querySelector(options.container);
          var closedClass = options.closedClass;
          var openClass = options.openClass;
          var toggler = instance.toggler;
          var target = toggler.dataset.target || toggler.getAttribute('href');

          instance._emit('closedStart.lexicon.sidenav');

          instance._subscribeSidenavTransitionEnd(content, function () {
            removeClass(container, 'sidenav-transition');
            removeClass(toggler, 'sidenav-transition');

            instance._emit('closed.lexicon.sidenav');
          });

          if (hasClass(content, openClass)) {
            var _setClasses3;

            setClasses(content, (_setClasses3 = {}, _defineProperty(_setClasses3, closedClass, true), _defineProperty(_setClasses3, openClass, false), _defineProperty(_setClasses3, 'sidenav-transition', true), _setClasses3));
          }

          addClass(container, 'sidenav-transition');
          addClass(toggler, 'sidenav-transition');
          setClasses(container, (_setClasses4 = {}, _defineProperty(_setClasses4, closedClass, true), _defineProperty(_setClasses4, openClass, false), _setClasses4));
          var nodes = document.querySelectorAll("[data-target=\"".concat(target, "\"], [href=\"").concat(target, "\"]"));
          Array.from(nodes).forEach(function (node) {
            setClasses(node, _defineProperty({
              active: false
            }, openClass, false));
            setClasses(node, _defineProperty({
              active: false
            }, openClass, false));
          });
        }
      },
      init: function init(toggler, options) {
        var instance = this;
        /**
         * For compatibility, we use a data-toggle attribute of
         * "liferay-sidenav" to distinguish our internal uses from
         * possible external uses of the old jQuery plugin (which used
         * "sidenav').
         */

        var useDataAttribute = toggler.dataset.toggle === 'liferay-sidenav';
        options = _objectSpread(_objectSpread({}, DEFAULTS), options);
        options.breakpoint = toInt(options.breakpoint);
        options.container = options.container || toggler.dataset.target || toggler.getAttribute('href');
        options.gutter = toInt(options.gutter);
        options.rtl = document.dir === 'rtl';
        options.width = toInt(options.width);
        options.widthOriginal = options.width; // instantiate using data attribute

        if (useDataAttribute) {
          options.closedClass = toggler.dataset.closedClass || 'closed';
          options.content = toggler.dataset.content;
          options.loadingIndicatorTPL = toggler.dataset.loadingIndicatorTpl || options.loadingIndicatorTPL;
          options.openClass = toggler.dataset.openClass || 'open';
          options.type = toggler.dataset.type;
          options.typeMobile = toggler.dataset.typeMobile;
          options.url = toggler.dataset.url;
          options.width = '';
        }

        instance.toggler = toggler;
        instance.options = options;
        instance.useDataAttribute = useDataAttribute;
        instance._emitter = new _metalEvents.default();

        instance._bindUI();

        instance._renderUI();
      },
      on: function on(event, listener) {
        return this._emitter.on(event, listener);
      },
      setHeight: function setHeight() {
        var instance = this;
        var options = instance.options;
        var container = document.querySelector(options.container);
        var type = instance.mobile ? options.typeMobile : options.type;

        if (type !== 'fixed' && type !== 'fixed-push') {
          var content = container.querySelector(options.content);
          var navigation = container.querySelector(options.navigation);
          var menu = container.querySelector('.sidenav-menu');
          var contentHeight = content.getBoundingClientRect().height;
          var navigationHeight = navigation.getBoundingClientRect().height;
          var tallest = px(Math.max(contentHeight, navigationHeight));
          setStyles(content, {
            'min-height': tallest
          });
          setStyles(navigation, {
            height: '100%',
            'min-height': tallest
          });
          setStyles(menu, {
            height: '100%',
            'min-height': tallest
          });
        }
      },
      show: function show() {
        var instance = this;

        if (instance.useDataAttribute) {
          instance.showSimpleSidenav();
        } else {
          instance.toggleNavigation(true);
        }
      },
      showSidenav: function showSidenav() {
        var instance = this;
        var mobile = instance.mobile;
        var options = instance.options;
        var container = document.querySelector(options.container);
        var content = container.querySelector(options.content);
        var navigation = container.querySelector(options.navigation);
        var menu = navigation.querySelector('.sidenav-menu');

        var sidenavRight = instance._isSidenavRight();

        var width = instance._getSidenavWidth();

        var offset = width + options.gutter;
        var url = options.url;

        if (url) {
          instance._loadUrl(menu, url);
        }

        setStyles(navigation, {
          width: px(width)
        });
        setStyles(menu, {
          width: px(width)
        });
        var positionDirection = options.rtl ? 'right' : 'left';

        if (sidenavRight) {
          positionDirection = options.rtl ? 'left' : 'right';
        }

        var paddingDirection = 'padding-' + positionDirection;
        var pushContentCssProperty = mobile ? positionDirection : paddingDirection;
        var type = mobile ? options.typeMobile : options.type;

        if (type !== 'fixed') {
          var navigationStartX = hasClass(container, 'open') ? offsetLeft(navigation) - options.gutter : offsetLeft(navigation) - offset;
          var contentStartX = offsetLeft(content);
          var contentWidth = toInt(getComputedStyle(content).width);
          var padding = '';

          if (options.rtl && sidenavRight || !options.rtl && options.position === 'left') {
            navigationStartX = offsetLeft(navigation) + offset;

            if (navigationStartX > contentStartX) {
              padding = navigationStartX - contentStartX;
            }
          } else if (options.rtl && options.position === 'left' || !options.rtl && sidenavRight) {
            if (navigationStartX < contentStartX + contentWidth) {
              padding = contentStartX + contentWidth - navigationStartX;

              if (padding >= offset) {
                padding = offset;
              }
            }
          }

          setStyles(content, _defineProperty({}, pushContentCssProperty, px(padding)));
        }
      },
      showSimpleSidenav: function showSimpleSidenav() {
        var instance = this;
        var options = instance.options;

        var simpleSidenavClosed = instance._isSimpleSidenavClosed();

        if (simpleSidenavClosed) {
          var _setClasses7, _setClasses8, _setClasses9;

          var content = document.querySelector(options.content);
          var container = document.querySelector(options.container);
          var closedClass = options.closedClass;
          var openClass = options.openClass;
          var toggler = instance.toggler;
          var url = toggler.dataset.url;

          if (url) {
            instance._loadUrl(container, url);
          }

          instance._emit('openStart.lexicon.sidenav');

          instance._subscribeSidenavTransitionEnd(content, function () {
            removeClass(container, 'sidenav-transition');
            removeClass(toggler, 'sidenav-transition');

            instance._emit('open.lexicon.sidenav');
          });

          setClasses(content, (_setClasses7 = {}, _defineProperty(_setClasses7, closedClass, false), _defineProperty(_setClasses7, openClass, true), _defineProperty(_setClasses7, 'sidenav-transition', true), _setClasses7));
          setClasses(container, (_setClasses8 = {}, _defineProperty(_setClasses8, closedClass, false), _defineProperty(_setClasses8, openClass, true), _defineProperty(_setClasses8, 'sidenav-transition', true), _setClasses8));
          setClasses(toggler, (_setClasses9 = {
            active: true
          }, _defineProperty(_setClasses9, openClass, true), _defineProperty(_setClasses9, 'sidenav-transition', true), _setClasses9));
        }
      },
      toggle: function toggle() {
        var instance = this;

        if (instance.useDataAttribute) {
          instance.toggleSimpleSidenav();
        } else {
          instance.toggleNavigation();
        }
      },
      toggleNavigation: function toggleNavigation(force) {
        var instance = this;
        var options = instance.options;
        var container = document.querySelector(options.container);
        var menu = container.querySelector('.sidenav-menu');
        var toggler = instance.toggler;
        var width = options.width;
        var closed = typeof force === 'boolean' ? force : hasClass(container, 'closed');

        var sidenavRight = instance._isSidenavRight();

        if (closed) {
          instance._emit('openStart.lexicon.sidenav');
        } else {
          instance._emit('closedStart.lexicon.sidenav');
        }

        instance._subscribeSidenavTransitionEnd(container, function () {
          var menu = container.querySelector('.sidenav-menu');

          if (hasClass(container, 'closed')) {
            instance.clearHeight();
            setClasses(toggler, {
              open: false,
              'sidenav-transition': false
            });

            instance._emit('closed.lexicon.sidenav');
          } else {
            setClasses(toggler, {
              open: true,
              'sidenav-transition': false
            });

            instance._emit('open.lexicon.sidenav');
          }

          if (instance.mobile) {
            // ios 8 fixed element disappears when trying to scroll
            menu.focus();
          }
        });

        if (closed) {
          instance.setHeight();
          setStyles(menu, {
            width: px(width)
          });
          var positionDirection = options.rtl ? 'left' : 'right';

          if (sidenavRight) {
            setStyles(menu, _defineProperty({}, positionDirection, ''));
          }
        }

        addClass(container, 'sidenav-transition');
        addClass(toggler, 'sidenav-transition');

        if (closed) {
          instance.showSidenav();
        } else {
          instance.hideSidenav();
        }

        setClasses(container, {
          closed: !closed,
          open: closed
        });
        setClasses(toggler, {
          active: closed,
          open: closed
        });
      },
      toggleSimpleSidenav: function toggleSimpleSidenav() {
        var instance = this;

        var simpleSidenavClosed = instance._isSimpleSidenavClosed();

        if (simpleSidenavClosed) {
          instance.showSimpleSidenav();
        } else {
          instance.hideSimpleSidenav();
        }
      },
      visible: function visible() {
        var instance = this;
        var closed;

        if (instance.useDataAttribute) {
          closed = instance._isSimpleSidenavClosed();
        } else {
          var container = document.querySelector(instance.options.container);
          closed = hasClass(container, 'sidenav-transition') ? !hasClass(container, 'closed') : hasClass(container, 'closed');
        }

        return !closed;
      }
    };

    SideNavigation.destroy = function destroy(element) {
      var instance = getInstance(element);

      if (instance) {
        instance.destroy();
      }
    };

    SideNavigation.hide = function hide(element) {
      var instance = getInstance(element);

      if (instance) {
        instance.hide();
      }
    };

    SideNavigation.initialize = function initialize(toggler) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      toggler = getElement(toggler);
      var instance = INSTANCE_MAP.get(toggler);

      if (!instance) {
        instance = new SideNavigation(toggler, options);
        INSTANCE_MAP.set(toggler, instance);
      }

      return instance;
    };

    SideNavigation.instance = getInstance;

    function onReady() {
      var togglers = document.querySelectorAll('[data-toggle="liferay-sidenav"]');
      Array.from(togglers).forEach(SideNavigation.initialize);
    }

    if (document.readyState !== 'loading') {
      // readyState is "interactive" or "complete".
      onReady();
    } else {
      document.addEventListener('DOMContentLoaded', function () {
        onReady();
      });
    }

    var _default = SideNavigation;
    exports.default = _default;
    //# sourceMappingURL=side_navigation.es.js.map
  }
});
//# sourceMappingURL=side_navigation.es.js.map