Liferay.Loader.define('frontend-js-web@4.0.46/liferay/util/address/get_regions.es', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = getRegions;

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Returns a list of regions by country
     * @callback callback
     * @param {!string} selectKey The selected region ID
     * @return {array} Array of regions by country
     */
    function getRegions(callback, selectKey) {
      if (typeof callback !== 'function') {
        throw new TypeError('Parameter callback must be a function');
      }

      if (typeof selectKey !== 'string') {
        throw new TypeError('Parameter selectKey must be a string');
      }

      Liferay.Service('/region/get-regions', {
        active: true,
        countryId: parseInt(selectKey, 10)
      }, callback);
    }
    //# sourceMappingURL=get_regions.es.js.map
  }
});
//# sourceMappingURL=get_regions.es.js.map