Liferay.Loader.define('frontend-js-web@4.0.46/liferay/util/fetch.es', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = defaultFetch;

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var DEFAULT_INIT = {
      credentials: 'include'
    };
    /**
     * Fetches a resource. A thin wrapper around ES6 Fetch API, with standardized
     * default configuration.
     * @param {!string|!Request} resource The URL to the resource, or a Resource
     * object.
     * @param {Object=} init An optional object containing custom configuration.
     * @return {Promise} A Promise that resolves to a Response object.
     */

    function defaultFetch(resource) {
      var init = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var headers = new Headers({
        'x-csrf-token': Liferay.authToken
      });
      new Headers(init.headers || {}).forEach(function (value, key) {
        headers.set(key, value);
      });

      var mergedInit = _objectSpread(_objectSpread({}, DEFAULT_INIT), init);

      mergedInit.headers = headers; // eslint-disable-next-line @liferay/portal/no-global-fetch

      return fetch(resource, mergedInit);
    }
    //# sourceMappingURL=fetch.es.js.map
  }
});
//# sourceMappingURL=fetch.es.js.map