Liferay.Loader.define("frontend-js-web@4.0.46/liferay/util/form/object_to_form_data.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = objectToFormData;

    var _metal = require("frontend-js-metal-web$metal");

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * Returns a FormData containing serialized object.
     * @param {!Object} obj Object to convert to a FormData
     * @param {FormData=} formData FormData object to recursively append the serialized data
     * @param {string=} namespace Property namespace for nested objects or arrays
     * @return {FormData} FormData with the serialized object
     * @review
     */
    function objectToFormData() {
      var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var formData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new FormData();
      var namespace = arguments.length > 2 ? arguments[2] : undefined;
      Object.entries(obj).forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            key = _ref2[0],
            value = _ref2[1];

        var formKey = namespace ? "".concat(namespace, "[").concat(key, "]") : key;

        if (Array.isArray(value)) {
          value.forEach(function (item) {
            objectToFormData(_defineProperty({}, formKey, item), formData);
          });
        } else if ((0, _metal.isObject)(value) && !(value instanceof File)) {
          objectToFormData(value, formData, formKey);
        } else {
          formData.append(formKey, value);
        }
      });
      return formData;
    }
    //# sourceMappingURL=object_to_form_data.es.js.map
  }
});
//# sourceMappingURL=object_to_form_data.es.js.map