Liferay.Loader.define("frontend-js-web@4.0.46/liferay/util/form/set_form_values.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', './get_form_element.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = setFormValues;

    var _metal = require("frontend-js-metal-web$metal");

    var _get_form_element = _interopRequireDefault(require("./get_form_element.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * Sets the form elements to given values.
     * @param {!Element} form The form DOM element
     * @param {!Object} data An Object containing names and values of form
     * elements
     * @review
     */
    function setFormValues(form, data) {
      if (!(0, _metal.isDef)(form) || form.nodeName !== 'FORM' || !(0, _metal.isObject)(data)) {
        return;
      }

      var entries = Object.entries(data);
      entries.forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            elementName = _ref2[0],
            elementValue = _ref2[1];

        var element = (0, _get_form_element.default)(form, elementName);

        if (element) {
          element.value = elementValue;
        }
      });
    }
    //# sourceMappingURL=set_form_values.es.js.map
  }
});
//# sourceMappingURL=set_form_values.es.js.map