Liferay.Loader.define("frontend-js-web@4.0.46/liferay/util/format_storage.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatStorage;

    var _metal = require("frontend-js-metal-web$metal");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var DEFAULT_OPTIONS = {
      addSpaceBeforeSuffix: false,
      decimalSeparator: '.',
      denominator: 1024.0,
      suffixGB: 'GB',
      suffixKB: 'KB',
      suffixMB: 'MB'
    };
    /**
     * Returns storage number formatted as a String
     * @param {!Number} size Storage size to be formatted
     * @param {Object} options Object representing optional parameters for
     * formatting storage size
     * @return {String} formattedStorage Final formatted storage outputted as a String
     * @review
     */

    function formatStorage(size) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var _DEFAULT_OPTIONS$opti = _objectSpread(_objectSpread({}, DEFAULT_OPTIONS), options),
          addSpaceBeforeSuffix = _DEFAULT_OPTIONS$opti.addSpaceBeforeSuffix,
          decimalSeparator = _DEFAULT_OPTIONS$opti.decimalSeparator,
          denominator = _DEFAULT_OPTIONS$opti.denominator,
          suffixGB = _DEFAULT_OPTIONS$opti.suffixGB,
          suffixKB = _DEFAULT_OPTIONS$opti.suffixKB,
          suffixMB = _DEFAULT_OPTIONS$opti.suffixMB;

      if (!(0, _metal.isNumber)(size)) {
        throw new TypeError('Parameter size must be a number');
      }

      var decimalPlaces = 0;
      var suffix = suffixKB;
      size /= denominator;

      if (size >= denominator) {
        suffix = suffixMB;
        size /= denominator;
        decimalPlaces = 1;
      }

      if (size >= denominator) {
        suffix = suffixGB;
        size /= denominator;
        decimalPlaces = 1;
      }

      var fixedSize = size.toFixed(decimalPlaces);

      if (decimalSeparator !== '.') {
        fixedSize = fixedSize.replace(/\./, decimalSeparator);
      }

      return fixedSize + (addSpaceBeforeSuffix ? ' ' : '') + suffix;
    }
    //# sourceMappingURL=format_storage.es.js.map
  }
});
//# sourceMappingURL=format_storage.es.js.map