Liferay.Loader.define("frontend-js-web@4.0.46/liferay/util/html_util", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.escapeHTML = escapeHTML;
    exports.unescapeHTML = unescapeHTML;
    exports.MAP_HTML_CHARS_ESCAPED = void 0;

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var MAP_HTML_CHARS_ESCAPED = {
      '"': '&#034;',
      '&': '&amp;',
      "'": '&#039;',
      '/': '&#047;',
      '<': '&lt;',
      '>': '&gt;',
      '`': '&#096;'
    };
    exports.MAP_HTML_CHARS_ESCAPED = MAP_HTML_CHARS_ESCAPED;
    var MAP_HTML_CHARS_UNESCAPED = {};
    Object.entries(MAP_HTML_CHARS_ESCAPED).forEach(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          char = _ref2[0],
          escapedChar = _ref2[1];

      MAP_HTML_CHARS_UNESCAPED[escapedChar] = char;
    });
    var HTML_UNESCAPED_VALUES = Object.keys(MAP_HTML_CHARS_ESCAPED);
    var HTML_ESCAPE = new RegExp("[".concat(HTML_UNESCAPED_VALUES.join(''), "]"), 'g');
    var HTML_UNESCAPE = /&([^\s;]+);/g;

    function escapeHTML(string) {
      return string.replace(HTML_ESCAPE, function (match) {
        return MAP_HTML_CHARS_ESCAPED[match];
      });
    }

    function unescapeHTML(string) {
      return string.replace(HTML_UNESCAPE, function (match) {
        return new DOMParser().parseFromString(match, 'text/html').documentElement.textContent;
      });
    }
    //# sourceMappingURL=html_util.js.map
  }
});
//# sourceMappingURL=html_util.js.map