Liferay.Loader.define("frontend-js-web@4.0.46/liferay/util/object_to_url_search_params.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = objectToURLSearchParams;

    var _metal = require("frontend-js-metal-web$metal");

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * Returns a FormData containing serialized object.
     * @param {!Object} obj Object to convert to a URLSearchParams
     * @return {URLSearchParams} URLSearchParams object with the set parameters
     * @review
     */
    function objectToURLSearchParams(obj) {
      if (!(0, _metal.isObject)(obj)) {
        throw new TypeError('Parameter obj must be an object');
      }

      var urlSearchParams = new URLSearchParams();
      Object.entries(obj).forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            key = _ref2[0],
            value = _ref2[1];

        if (Array.isArray(value)) {
          for (var i = 0; i < value.length; i++) {
            urlSearchParams.append(key, value[i]);
          }
        } else {
          urlSearchParams.append(key, value);
        }
      });
      return urlSearchParams;
    }
    //# sourceMappingURL=object_to_url_search_params.es.js.map
  }
});
//# sourceMappingURL=object_to_url_search_params.es.js.map