/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.baseline;

import com.liferay.gradle.plugins.baseline.internal.work.BaselineWorkAction;
import com.liferay.gradle.plugins.baseline.internal.work.BaselineWorkParameters;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class BaselineTask
extends DefaultTask
implements VerificationTask {
    private Configuration _baselineConfiguration;
    private Object _bndFile;
    private boolean _forceCalculatedVersion;
    private boolean _ignoreExcessiveVersionIncreases;
    private boolean _ignoreFailures;
    private String _logFileName;
    private Object _newJarFile;
    private File _oldJarFile;
    private boolean _reportDiff;
    private boolean _reportOnlyDirtyPackages;
    private Object _sourceDir;
    private final WorkerExecutor _workerExecutor;

    @Inject
    public BaselineTask(WorkerExecutor workerExecutor) {
        this._workerExecutor = workerExecutor;
        this._logFileName = "baseline/" + this.getName() + ".log";
    }

    @TaskAction
    public void baseline() {
        WorkQueue workQueue = this._workerExecutor.noIsolation();
        workQueue.submit(BaselineWorkAction.class, (Action)new Action<BaselineWorkParameters>(){

            public void execute(BaselineWorkParameters baselineWorkParameters) {
                Logger logger = BaselineTask.this.getLogger();
                if (logger.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Comparing ");
                    sb.append(BaselineTask.this.getNewJarFile());
                    sb.append(" against ");
                    sb.append(BaselineTask.this.getOldJarFile());
                    logger.info(sb.toString());
                }
                RegularFileProperty bndFileRegularFileProperty = baselineWorkParameters.getBndFile();
                bndFileRegularFileProperty.set(BaselineTask.this.getBndFile());
                Property<Boolean> forceCalculatedVersionProperty = baselineWorkParameters.getForceCalculatedVersion();
                forceCalculatedVersionProperty.set((Object)BaselineTask.this.isForceCalculatedVersion());
                Property<Boolean> ignoreExcessiveVersionIncreasesProperty = baselineWorkParameters.getIgnoreExcessiveVersionIncreases();
                ignoreExcessiveVersionIncreasesProperty.set((Object)BaselineTask.this.isIgnoreExcessiveVersionIncreases());
                Property<Boolean> ignoreFailuresProperty = baselineWorkParameters.getIgnoreFailures();
                ignoreFailuresProperty.set((Object)BaselineTask.this.getIgnoreFailures());
                RegularFileProperty logFileRegularFileProperty = baselineWorkParameters.getLogFile();
                logFileRegularFileProperty.set(BaselineTask.this.getLogFile());
                RegularFileProperty newJarFileRegularFileProperty = baselineWorkParameters.getNewJarFile();
                newJarFileRegularFileProperty.set(BaselineTask.this.getNewJarFile());
                RegularFileProperty oldJarFileRegularFileProperty = baselineWorkParameters.getOldJarFile();
                oldJarFileRegularFileProperty.set(BaselineTask.this.getOldJarFile());
                Property<Boolean> reportDiffProperty = baselineWorkParameters.getReportDiff();
                reportDiffProperty.set((Object)BaselineTask.this.isReportDiff());
                Property<Boolean> reportOnlyDirtyPackagesProperty = baselineWorkParameters.getReportOnlyDirtyPackages();
                reportOnlyDirtyPackagesProperty.set((Object)BaselineTask.this.isReportOnlyDirtyPackages());
                DirectoryProperty sourceDirDirectoryProperty = baselineWorkParameters.getSourceDir();
                sourceDirDirectoryProperty.set(BaselineTask.this.getSourceDir());
            }
        });
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Configuration getBaselineConfiguration() {
        return this._baselineConfiguration;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getBndFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._bndFile);
    }

    public boolean getIgnoreFailures() {
        return this._ignoreFailures;
    }

    @Optional
    @OutputFile
    public File getLogFile() {
        if (Validator.isNull((String)this._logFileName)) {
            return null;
        }
        Project project = this.getProject();
        ExtensionContainer extensionContainer = project.getExtensions();
        ReportingExtension reportingExtension = (ReportingExtension)extensionContainer.findByType(ReportingExtension.class);
        if (reportingExtension != null) {
            return reportingExtension.file(this._logFileName);
        }
        return GradleUtil.toFile((Project)project, (Object)this._logFileName);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getNewJarFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._newJarFile);
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getSourceDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceDir);
    }

    @Input
    public boolean isForceCalculatedVersion() {
        return this._forceCalculatedVersion;
    }

    @Input
    public boolean isIgnoreExcessiveVersionIncreases() {
        return this._ignoreExcessiveVersionIncreases;
    }

    @Input
    public boolean isReportDiff() {
        return this._reportDiff;
    }

    @Input
    public boolean isReportOnlyDirtyPackages() {
        return this._reportOnlyDirtyPackages;
    }

    public void setBaselineConfiguration(Configuration baselineConfiguration) {
        this._baselineConfiguration = baselineConfiguration;
    }

    public void setBndFile(Object bndFile) {
        this._bndFile = bndFile;
    }

    public void setForceCalculatedVersion(boolean forceCalculatedVersion) {
        this._forceCalculatedVersion = forceCalculatedVersion;
    }

    public void setIgnoreExcessiveVersionIncreases(boolean ignoreExcessiveVersionIncreases) {
        this._ignoreExcessiveVersionIncreases = ignoreExcessiveVersionIncreases;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this._ignoreFailures = ignoreFailures;
    }

    public void setLogFileName(String logFileName) {
        this._logFileName = logFileName;
    }

    public void setNewJarFile(Object newJarFile) {
        this._newJarFile = newJarFile;
    }

    public void setReportDiff(boolean reportDiff) {
        this._reportDiff = reportDiff;
    }

    public void setReportOnlyDirtyPackages(boolean reportOnlyDirtyPackages) {
        this._reportOnlyDirtyPackages = reportOnlyDirtyPackages;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }

    @Internal
    protected File getOldJarFile() {
        if (this._oldJarFile != null) {
            return this._oldJarFile;
        }
        Configuration baselineConfiguration = this.getBaselineConfiguration();
        this._oldJarFile = baselineConfiguration.getSingleFile();
        return this._oldJarFile;
    }
}

