/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.change.log.builder;

import com.liferay.gradle.plugins.change.log.builder.BuildChangeLogTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;

public class ChangeLogBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_CHANGE_LOG_TASK_NAME = "buildChangeLog";
    private static final String _CHANGE_LOG_FILE_NAME = "liferay-releng.changelog";

    public void apply(Project project) {
        this._addTaskBuildChangeLog(project);
    }

    private BuildChangeLogTask _addTaskBuildChangeLog(Project project) {
        final BuildChangeLogTask buildChangeLogTask = (BuildChangeLogTask)GradleUtil.addTask((Project)project, (String)BUILD_CHANGE_LOG_TASK_NAME, BuildChangeLogTask.class);
        buildChangeLogTask.setChangeLogHeader(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Project project = buildChangeLogTask.getProject();
                return "Bundle Version " + project.getVersion();
            }
        });
        buildChangeLogTask.setChangeLogFile(_CHANGE_LOG_FILE_NAME);
        buildChangeLogTask.setDescription("Builds the change log file for this project.");
        buildChangeLogTask.setDirs(project.getProjectDir());
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaLibraryPlugin.class, (Action)new Action<JavaLibraryPlugin>(){

            public void execute(JavaLibraryPlugin javaLibraryPlugin) {
                ChangeLogBuilderPlugin.this._configureTaskBuildChangeLogForJavaLibraryPlugin(buildChangeLogTask);
            }
        });
        return buildChangeLogTask;
    }

    private void _configureTaskBuildChangeLogForJavaLibraryPlugin(final BuildChangeLogTask buildChangeLogTask) {
        buildChangeLogTask.setChangeLogFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = ChangeLogBuilderPlugin.this._getResourcesDir(buildChangeLogTask.getProject());
                return new File(resourcesDir, "META-INF/liferay-releng.changelog");
            }
        });
    }

    private File _getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this._getSrcDir(sourceSet.getResources());
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

