/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.dependency.local.copy;

import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.tasks.Sync;

public class DependencyLocalCopyPlugin
implements Plugin<Project> {
    public static final String LOCAL_COPY_GROUP = "local.copy";
    public static final String SYNC_LOCAL_COPY_TASK_NAME = "syncLocalCopy";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaLibraryPlugin.class);
        Task syncLocalCopyTask = this._addTaskSyncLocalCopy(project);
        this._configureConfigurations(syncLocalCopyTask);
        this._configureTaskCompileJava(syncLocalCopyTask);
    }

    private Task _addTaskSyncLocalCopy(Project project) {
        Task task = project.task(SYNC_LOCAL_COPY_TASK_NAME);
        task.setDescription("Creates local copies of all configured project dependencies.");
        return task;
    }

    private Sync _addTaskSyncLocalCopy(final Project project, Project dependencyProject, boolean transitive) {
        final String dependencyProjectPath = dependencyProject.getPath();
        Sync sync = (Sync)GradleUtil.addTask((Project)project, (String)(SYNC_LOCAL_COPY_TASK_NAME + dependencyProjectPath.replace(':', '_')), Sync.class);
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)sync.getName());
        DependencyHandler dependencyHandler = project.getDependencies();
        ProjectDependency projectDependency = (ProjectDependency)dependencyHandler.add(configuration.getName(), (Object)dependencyProject);
        projectDependency.setTransitive(transitive);
        sync.from(new Object[]{configuration});
        sync.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return DependencyLocalCopyPlugin.this._getLocalCopyDir(project, dependencyProjectPath);
            }
        });
        sync.setDescription("Creates a local copy of " + dependencyProject + ".");
        return sync;
    }

    private void _configureConfiguration(final Task syncLocalCopyTask, final Configuration configuration) {
        DependencySet dependencySet = configuration.getDependencies();
        dependencySet.withType(ExternalDependency.class, (Action)new Action<ExternalDependency>(){

            public void execute(ExternalDependency externalDependency) {
                if (!DependencyLocalCopyPlugin.LOCAL_COPY_GROUP.equals(externalDependency.getGroup())) {
                    return;
                }
                String dependencyProjectPath = externalDependency.getName();
                Project project = syncLocalCopyTask.getProject();
                Project dependencyProject = project.findProject(dependencyProjectPath);
                if (dependencyProject != null) {
                    Sync sync = DependencyLocalCopyPlugin.this._addTaskSyncLocalCopy(project, dependencyProject, externalDependency.isTransitive());
                    syncLocalCopyTask.dependsOn(new Object[]{sync});
                } else {
                    HashMap<String, String> excludeProperties = new HashMap<String, String>();
                    excludeProperties.put("group", externalDependency.getGroup());
                    excludeProperties.put("module", dependencyProjectPath);
                    configuration.exclude(excludeProperties);
                    ConfigurableFileTree fileTree = project.fileTree((Object)DependencyLocalCopyPlugin.this._getLocalCopyDir(project, dependencyProjectPath));
                    GradleUtil.addDependency((Project)project, (String)configuration.getName(), (FileCollection)fileTree);
                }
            }
        });
        ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
        final DependencySubstitutions dependencySubstitutions = resolutionStrategy.getDependencySubstitution();
        dependencySubstitutions.all((Action)new Action<DependencySubstitution>(){

            public void execute(DependencySubstitution dependencySubstitution) {
                ComponentSelector componentSelector = dependencySubstitution.getRequested();
                if (!(componentSelector instanceof ModuleComponentSelector)) {
                    return;
                }
                ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)componentSelector;
                if (!DependencyLocalCopyPlugin.LOCAL_COPY_GROUP.equals(moduleComponentSelector.getGroup())) {
                    return;
                }
                dependencySubstitution.useTarget((Object)dependencySubstitutions.project(moduleComponentSelector.getModule()));
            }
        });
    }

    private void _configureConfigurations(final Task syncLocalCopyTask) {
        Project project = syncLocalCopyTask.getProject();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        configurationContainer.all((Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                DependencyLocalCopyPlugin.this._configureConfiguration(syncLocalCopyTask, configuration);
            }
        });
    }

    private void _configureTaskCompileJava(Task syncLocalCopyTask) {
        Task task = GradleUtil.getTask((Project)syncLocalCopyTask.getProject(), (String)"compileJava");
        task.finalizedBy(new Object[]{syncLocalCopyTask});
    }

    private File _getLocalCopyDir(Project project, String dependencyProjectPath) {
        File localCopyDir = new File(project.getBuildDir(), "local-copy");
        return new File(localCopyDir, dependencyProjectPath.replace(':', File.separatorChar));
    }
}

