/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.javadoc.formatter;

import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.GradleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.util.CollectionUtils;

@CacheableTask
public class FormatJavadocTask
extends JavaExec {
    private Object _author = "Brian Wing Shun Chan";
    private boolean _generateXml;
    private boolean _initializeMissingJavadocs;
    private final Set<Object> _limits = new LinkedHashSet<Object>();
    private Object _outputFilePrefix = "javadocs";
    private boolean _updateJavadocs;

    public FormatJavadocTask() {
        Property mainClass = this.getMainClass();
        mainClass.set((Object)"com.liferay.javadoc.formatter.JavadocFormatter");
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    @Input
    public String getAuthor() {
        return GradleUtil.toString((Object)this._author);
    }

    @Input
    public List<String> getLimits() {
        return GradleUtil.toStringList(this._limits);
    }

    @Input
    public String getOutputFilePrefix() {
        return GradleUtil.toString((Object)this._outputFilePrefix);
    }

    @Input
    public boolean isGenerateXml() {
        return this._generateXml;
    }

    @Input
    public boolean isInitializeMissingJavadocs() {
        return this._initializeMissingJavadocs;
    }

    @Input
    public boolean isUpdateJavadocs() {
        return this._updateJavadocs;
    }

    public FormatJavadocTask limits(Iterable<Object> limits) {
        GUtil.addToCollection(this._limits, limits);
        return this;
    }

    public FormatJavadocTask limits(Object ... limits) {
        return this.limits(Arrays.asList(limits));
    }

    public void setAuthor(Object author) {
        this._author = author;
    }

    public void setGenerateXml(boolean generateXml) {
        this._generateXml = generateXml;
    }

    public void setInitializeMissingJavadocs(boolean initializeMissingJavadocs) {
        this._initializeMissingJavadocs = initializeMissingJavadocs;
    }

    public void setLimits(Iterable<Object> limits) {
        this._limits.clear();
        this.limits(limits);
    }

    public void setLimits(Object ... limits) {
        this.setLimits(Arrays.asList(limits));
    }

    public void setOutputFilePrefix(Object outputFilePrefix) {
        this._outputFilePrefix = outputFilePrefix;
    }

    public void setUpdateJavadocs(boolean updateJavadocs) {
        this._updateJavadocs = updateJavadocs;
    }

    @Internal
    protected List<String> getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("javadoc.author=" + this.getAuthor());
        args.add("javadoc.generate.xml=" + this.isGenerateXml());
        args.add("javadoc.init=" + this.isInitializeMissingJavadocs());
        args.add("javadoc.input.dir=./");
        args.add("javadoc.limit=" + CollectionUtils.join((String)",", this.getLimits()));
        args.add("javadoc.output.file.prefix=" + this.getOutputFilePrefix());
        args.add("javadoc.update=" + this.isUpdateJavadocs());
        return args;
    }
}

