/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.javadoc.formatter;

import com.liferay.gradle.plugins.javadoc.formatter.FormatJavadocTask;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;

public class JavadocFormatterPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "javadocFormatter";
    public static final String FORMAT_JAVADOC_TASK_NAME = "formatJavadoc";

    public void apply(Project project) {
        Configuration javadocFormatterConfiguration = this.addConfigurationJavadocFormatter(project);
        this.addTaskFormatJavadoc(project);
        this.configureTasksFormatJavadoc(project, (FileCollection)javadocFormatterConfiguration);
    }

    protected Configuration addConfigurationJavadocFormatter(final Project project) {
        final Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                JavadocFormatterPlugin.this.addDependenciesJavadocFormatter(project);
            }
        });
        configuration.setDescription("Configures Liferay Javadoc Formatter for this project.");
        configuration.setVisible(false);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaLibraryPlugin.class, (Action)new Action<JavaLibraryPlugin>(){

            public void execute(JavaLibraryPlugin javaLibraryPlugin) {
                JavadocFormatterPlugin.this.configureConfigurationJavadocFormatterForJavaLibraryPlugin(project, configuration);
            }
        });
        return configuration;
    }

    protected void addDependenciesJavadocFormatter(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.javadoc.formatter", (String)"latest.release");
    }

    protected FormatJavadocTask addTaskFormatJavadoc(Project project) {
        FormatJavadocTask formatJavadocTask = (FormatJavadocTask)GradleUtil.addTask((Project)project, (String)FORMAT_JAVADOC_TASK_NAME, FormatJavadocTask.class);
        formatJavadocTask.setDescription("Runs Liferay Javadoc Formatter to format files.");
        formatJavadocTask.setGroup("formatting");
        return formatJavadocTask;
    }

    protected void configureConfigurationJavadocFormatterForJavaLibraryPlugin(Project project, Configuration configuration) {
        Configuration apiConfiguration = GradleUtil.getConfiguration((Project)project, (String)"api");
        configuration.extendsFrom(new Configuration[]{apiConfiguration});
    }

    protected void configureTaskFormatJavadoc(FormatJavadocTask formatJavadocTask, FileCollection classpath) {
        String update;
        String limit;
        String init;
        formatJavadocTask.setClasspath(classpath);
        String generateXml = GradleUtil.getTaskPrefixedProperty((Task)formatJavadocTask, (String)"generate.xml");
        if (Validator.isNotNull((String)generateXml)) {
            formatJavadocTask.setGenerateXml(Boolean.parseBoolean(generateXml));
        }
        if (Validator.isNotNull((String)(init = GradleUtil.getTaskPrefixedProperty((Task)formatJavadocTask, (String)"init")))) {
            formatJavadocTask.setInitializeMissingJavadocs(Boolean.parseBoolean(init));
        }
        if (Validator.isNotNull((String)(limit = GradleUtil.getTaskPrefixedProperty((Task)formatJavadocTask, (String)"limit")))) {
            formatJavadocTask.setLimits(limit.split(","));
        }
        if (Validator.isNotNull((String)(update = GradleUtil.getTaskPrefixedProperty((Task)formatJavadocTask, (String)"update")))) {
            formatJavadocTask.setUpdateJavadocs(Boolean.parseBoolean(update));
        }
    }

    protected void configureTasksFormatJavadoc(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatJavadocTask.class, (Action)new Action<FormatJavadocTask>(){

            public void execute(FormatJavadocTask formatJavadoc) {
                JavadocFormatterPlugin.this.configureTaskFormatJavadoc(formatJavadoc, classpath);
            }
        });
    }
}

