/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import groovy.util.Node;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;

public class EclipseDefaultsPlugin
extends BaseDefaultsPlugin<EclipsePlugin> {
    public static final Plugin<Project> INSTANCE = new EclipseDefaultsPlugin();
    private static final String _CLEAN_ECLIPSE_TASK_NAME = "cleanEclipse";
    private static final String _ECLIPSE_TASK_NAME = "eclipse";
    private static final String[] _FILTERED_DIR_NAMES = new String[]{".git", ".gradle", "build", "node_modules", "node_modules_cache", "tmp"};

    @Override
    protected void applyPluginDefaults(final Project project, EclipsePlugin eclipsePlugin) {
        ExtensionContainer extensionContainer = project.getExtensions();
        final EclipseModel eclipseModelExtension = (EclipseModel)extensionContainer.getByType(EclipseModel.class);
        TaskProvider eclipseTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)_ECLIPSE_TASK_NAME);
        this._configureTaskEclipseProvider((TaskProvider<Task>)eclipseTaskProvider);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.configureEach((Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                if (plugin instanceof JavaPlugin) {
                    EclipseDefaultsPlugin.this._configurePluginJava(project, eclipseModelExtension);
                }
            }
        });
        File portalRootDir = GradleUtil.getRootDir((Project)project.getRootProject(), (String)"portal-impl");
        this._configureEclipseClasspath(project, eclipseModelExtension);
        this._configureEclipseProject(project, eclipseModelExtension, (TaskProvider<Task>)eclipseTaskProvider, portalRootDir);
    }

    @Override
    protected Class<EclipsePlugin> getPluginClass() {
        return EclipsePlugin.class;
    }

    private EclipseDefaultsPlugin() {
    }

    private void _configureEclipseClasspath(Project project, EclipseModel eclipseModelExtension) {
        EclipseClasspath eclipseClasspath = eclipseModelExtension.getClasspath();
        XmlFileContentMerger fileContentMerger = eclipseClasspath.getFile();
        Closure<Void> closure = new Closure<Void>((Object)project){

            public void doCall(Classpath classpath) {
                List classpathEntries = classpath.getEntries();
                Iterator iterator = classpathEntries.iterator();
                while (iterator.hasNext()) {
                    ClasspathEntry classpathEntry = (ClasspathEntry)iterator.next();
                    if (!(classpathEntry instanceof AbstractClasspathEntry)) continue;
                    AbstractClasspathEntry abstractClasspathEntry = (AbstractClasspathEntry)classpathEntry;
                    String kind = abstractClasspathEntry.getKind();
                    String path = abstractClasspathEntry.getPath();
                    if (!kind.equals("lib") || !path.endsWith(".pom")) continue;
                    iterator.remove();
                }
            }
        };
        fileContentMerger.whenMerged((Closure)closure);
    }

    private void _configureEclipseProject(Project project, EclipseModel eclipseModelExtension, TaskProvider<Task> eclipseTaskProvider, File portalRootDir) {
        String gitWorkingBranchName;
        EclipseProject eclipseProject = eclipseModelExtension.getProject();
        String eclipseProjectName = project.getName();
        String gitWorkingBranch = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)eclipseTaskProvider.getName(), (String)"git.working.branch");
        if (Boolean.parseBoolean(gitWorkingBranch) && portalRootDir != null && portalRootDir.exists() && Validator.isNotNull((String)(gitWorkingBranchName = GradleUtil.getProperty((ExtensionAware)project, (String)"git.working.branch.name", (String)null)))) {
            eclipseProjectName = eclipseProjectName + '-' + gitWorkingBranchName;
        }
        eclipseProject.setName(eclipseProjectName);
        List natures = eclipseProject.getNatures();
        natures.add("com.liferay.ide.core.liferayNature");
        Action<XmlProvider> action = new Action<XmlProvider>(){

            public void execute(XmlProvider xmlProvider) {
                Node projectDescriptionNode = xmlProvider.asNode();
                Node filteredResourcesNode = projectDescriptionNode.appendNode((Object)"filteredResources");
                Node filterNode = filteredResourcesNode.appendNode((Object)"filter");
                filterNode.appendNode((Object)"id", (Object)System.currentTimeMillis());
                filterNode.appendNode((Object)"name");
                filterNode.appendNode((Object)"type", (Object)"26");
                Node matcherNode = filterNode.appendNode((Object)"matcher");
                matcherNode.appendNode((Object)"id", (Object)"org.eclipse.ui.ide.orFilterMatcher");
                Node argumentsNode = matcherNode.appendNode((Object)"arguments");
                for (String filteredDirName : _FILTERED_DIR_NAMES) {
                    Node curMatcherNode = argumentsNode.appendNode((Object)"matcher");
                    curMatcherNode.appendNode((Object)"arguments", (Object)("1.0-name-matches-false-false-" + filteredDirName));
                    curMatcherNode.appendNode((Object)"id", (Object)"org.eclipse.ui.ide.multiFilter");
                }
            }
        };
        XmlFileContentMerger xmlFileContentMerger = eclipseProject.getFile();
        xmlFileContentMerger.withXml((Action)action);
    }

    private void _configurePluginJava(Project project, EclipseModel eclipseModelExtension) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration compileOnlyConfiguration = configurationContainer.getByName("compileOnly");
        EclipseClasspath eclipseClasspath = eclipseModelExtension.getClasspath();
        Collection configurations = eclipseClasspath.getPlusConfigurations();
        configurations.add(compileOnlyConfiguration);
    }

    private void _configureTaskEclipseProvider(TaskProvider<Task> eclipseTaskProvider) {
        eclipseTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task eclipseTask) {
                eclipseTask.dependsOn(new Object[]{EclipseDefaultsPlugin._CLEAN_ECLIPSE_TASK_NAME});
            }
        });
    }
}

