/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.python.PythonPlugin;
import com.liferay.gradle.plugins.source.formatter.FormatSourceTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import com.pswidersk.gradle.python.VenvTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SourceFormatterDefaultsPlugin
extends BaseDefaultsPlugin<SourceFormatterPlugin> {
    public static final Plugin<Project> INSTANCE = new SourceFormatterDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.source.formatter";

    @Override
    protected void applyPluginDefaults(final Project project, SourceFormatterPlugin sourceFormatterPlugin) {
        PortalTools.addPortalToolDependencies(project, "sourceFormatter", "com.liferay", _PORTAL_TOOL_NAME);
        final TaskProvider checkSourceFormattingTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"checkSourceFormatting", FormatSourceTask.class);
        final TaskProvider formatSourceTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"formatSource", FormatSourceTask.class);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatSourceTask.class, (Action)new Action<FormatSourceTask>(){

            public void execute(FormatSourceTask formatSourceTask) {
                SourceFormatterDefaultsPlugin.this._configureTaskFormatSource(formatSourceTask);
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(NodePlugin.class, (Action)new Action<NodePlugin>(){

            public void execute(NodePlugin nodePlugin) {
                SourceFormatterDefaultsPlugin.this._configurePluginNode(project, (TaskProvider<FormatSourceTask>)checkSourceFormattingTaskProvider, (TaskProvider<FormatSourceTask>)formatSourceTaskProvider);
            }
        });
        pluginContainer.withType(PythonPlugin.class, (Action)new Action<PythonPlugin>(){

            public void execute(PythonPlugin pythonPlugin) {
                SourceFormatterDefaultsPlugin.this._configurePluginPython(project, (TaskProvider<FormatSourceTask>)checkSourceFormattingTaskProvider, (TaskProvider<FormatSourceTask>)formatSourceTaskProvider);
            }
        });
    }

    @Override
    protected Class<SourceFormatterPlugin> getPluginClass() {
        return SourceFormatterPlugin.class;
    }

    private void _configurePluginNode(Project project, TaskProvider<FormatSourceTask> checkSourceFormattingTaskProvider, TaskProvider<FormatSourceTask> formatSourceTaskProvider) {
        String skipNodeTask;
        TaskProvider packageRunFormatTaskProvider;
        String skipNodeTask2;
        final TaskProvider packageRunCheckFormatTaskProvider = GradleUtil.fetchTaskProvider((Project)project, (String)"packageRunCheckFormat");
        if (packageRunCheckFormatTaskProvider != null && !Boolean.parseBoolean(skipNodeTask2 = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)checkSourceFormattingTaskProvider.getName(), (String)"skip.node.task"))) {
            checkSourceFormattingTaskProvider.configure((Action)new Action<FormatSourceTask>(){

                public void execute(FormatSourceTask checkSourceFormattingFormatSourceTask) {
                    checkSourceFormattingFormatSourceTask.finalizedBy(new Object[]{packageRunCheckFormatTaskProvider});
                }
            });
        }
        if ((packageRunFormatTaskProvider = GradleUtil.fetchTaskProvider((Project)project, (String)"packageRunFormat")) != null && !Boolean.parseBoolean(skipNodeTask = GradleUtil.getTaskPrefixedProperty((String)project.getPath(), (String)formatSourceTaskProvider.getName(), (String)"skip.node.task"))) {
            formatSourceTaskProvider.configure((Action)new Action<FormatSourceTask>(){

                public void execute(FormatSourceTask formatSourceTask) {
                    formatSourceTask.finalizedBy(new Object[]{packageRunFormatTaskProvider});
                }
            });
        }
    }

    private void _configurePluginPython(Project project, final TaskProvider<FormatSourceTask> checkSourceFormattingTaskProvider, final TaskProvider<FormatSourceTask> formatSourceTaskProvider) {
        TaskProvider checkPythonFormattingTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"checkPythonFormatting", VenvTask.class);
        TaskProvider formatPythonTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"formatPython", VenvTask.class);
        checkPythonFormattingTaskProvider.configure((Action)new Action<VenvTask>(){

            public void execute(VenvTask checkPythonFormattingTask) {
                checkPythonFormattingTask.finalizedBy(new Object[]{checkSourceFormattingTaskProvider});
                checkPythonFormattingTask.setEnabled(false);
            }
        });
        formatPythonTaskProvider.configure((Action)new Action<VenvTask>(){

            public void execute(VenvTask formatPythonTask) {
                formatPythonTask.finalizedBy(new Object[]{formatSourceTaskProvider});
                formatPythonTask.setEnabled(false);
            }
        });
    }

    private void _configureTaskFormatSource(FormatSourceTask formatSourceTask) {
        String validateCommitMessages;
        String sourceFileExtensions;
        String sourceFileNames;
        String showDebugInformation;
        String processorThreadCount;
        String printErrors;
        String maxLineLength;
        String javaParserEnabled;
        String includeSubrepositories;
        String gitWorkingBranchName;
        String formatLocalChanges;
        String formatLatestAuthor;
        String formatCurrentBranch;
        String failOnHasWarning;
        String failOnAutoFix;
        String checkNames;
        String checkCategoryNames;
        String baseDirName;
        Project project = formatSourceTask.getProject();
        String autoFix = GradleUtil.getProperty((ExtensionAware)project, (String)"source.auto.fix", (String)null);
        if (Validator.isNotNull((String)autoFix)) {
            formatSourceTask.setAutoFix(Boolean.parseBoolean(autoFix));
        }
        if (Validator.isNotNull((String)(baseDirName = GradleUtil.getProperty((ExtensionAware)project, (String)"source.base.dir", (String)null)))) {
            formatSourceTask.setBaseDirName(baseDirName);
        }
        if (Validator.isNotNull((String)(checkCategoryNames = GradleUtil.getProperty((ExtensionAware)project, (String)"source.check.category.names", (String)null)))) {
            formatSourceTask.setCheckCategoryNames(checkCategoryNames.split(","));
        }
        if (Validator.isNotNull((String)(checkNames = GradleUtil.getProperty((ExtensionAware)project, (String)"source.check.names", (String)null)))) {
            formatSourceTask.setCheckNames(checkNames.split(","));
        }
        if (Validator.isNotNull((String)(failOnAutoFix = GradleUtil.getProperty((ExtensionAware)project, (String)"source.fail.on.auto.fix", (String)null)))) {
            formatSourceTask.setFailOnAutoFix(Boolean.parseBoolean(failOnAutoFix));
        }
        if (Validator.isNotNull((String)(failOnHasWarning = GradleUtil.getProperty((ExtensionAware)project, (String)"source.fail.on.has.warning", (String)null)))) {
            formatSourceTask.setFailOnHasWarning(Boolean.parseBoolean(failOnHasWarning));
        }
        if (Validator.isNotNull((String)(formatCurrentBranch = GradleUtil.getProperty((ExtensionAware)project, (String)"format.current.branch", (String)null)))) {
            formatSourceTask.setFormatCurrentBranch(Boolean.parseBoolean(formatCurrentBranch));
        }
        if (Validator.isNotNull((String)(formatLatestAuthor = GradleUtil.getProperty((ExtensionAware)project, (String)"format.latest.author", (String)null)))) {
            formatSourceTask.setFormatLatestAuthor(Boolean.parseBoolean(formatLatestAuthor));
        }
        if (Validator.isNotNull((String)(formatLocalChanges = GradleUtil.getProperty((ExtensionAware)project, (String)"format.local.changes", (String)null)))) {
            formatSourceTask.setFormatLocalChanges(Boolean.parseBoolean(formatLocalChanges));
        }
        if (Validator.isNotNull((String)(gitWorkingBranchName = GradleUtil.getProperty((ExtensionAware)project, (String)"git.working.branch.name", (String)null)))) {
            formatSourceTask.setGitWorkingBranchName(gitWorkingBranchName);
        }
        if (Validator.isNotNull((String)(includeSubrepositories = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.include.subrepositories", (String)null)))) {
            formatSourceTask.setIncludeSubrepositories(Boolean.parseBoolean(includeSubrepositories));
        }
        if (Validator.isNotNull((String)(javaParserEnabled = GradleUtil.getProperty((ExtensionAware)project, (String)"java.parser.enabled", (String)null)))) {
            formatSourceTask.setJavaParserEnabled(Boolean.parseBoolean(javaParserEnabled));
        }
        if (Validator.isNotNull((String)(maxLineLength = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.max.line.length", (String)null)))) {
            formatSourceTask.setMaxLineLength(Integer.parseInt(maxLineLength));
        }
        if (Validator.isNotNull((String)(printErrors = GradleUtil.getProperty((ExtensionAware)project, (String)"source.print.errors", (String)null)))) {
            formatSourceTask.setPrintErrors(Boolean.parseBoolean(printErrors));
        }
        if (Validator.isNotNull((String)(processorThreadCount = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.processor.thread.count", (String)null)))) {
            formatSourceTask.setProcessorThreadCount(Integer.parseInt(processorThreadCount));
        }
        if (Validator.isNotNull((String)(showDebugInformation = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.debug.information", (String)null)))) {
            formatSourceTask.setShowDebugInformation(Boolean.parseBoolean(showDebugInformation));
        }
        if (Validator.isNotNull((String)(sourceFileNames = GradleUtil.getProperty((ExtensionAware)project, (String)"source.files", (String)null)))) {
            formatSourceTask.setFileNames(sourceFileNames.split(","));
        }
        if (Validator.isNotNull((String)(sourceFileExtensions = GradleUtil.getProperty((ExtensionAware)project, (String)"source.file.extensions", (String)null)))) {
            formatSourceTask.setFileExtensions(sourceFileExtensions.split(","));
        }
        if (Validator.isNotNull((String)(validateCommitMessages = GradleUtil.getProperty((ExtensionAware)project, (String)"validate.commit.message", (String)null)))) {
            formatSourceTask.setValidateCommitMessages(Boolean.parseBoolean(validateCommitMessages));
        }
    }
}

