/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util.tasks;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GUtil;

public class ConcatenateTask
extends DefaultTask {
    private Object _destinationFile;
    private final List<Object> _sourceFiles = new ArrayList<Object>();

    @TaskAction
    public void concatenate() throws Exception {
        FileUtil.concatenate(this.getDestinationFile(), (Iterable<File>)this.getSourceFiles());
    }

    @OutputFile
    public File getDestinationFile() {
        return GradleUtil.toFile(this.getProject(), this._destinationFile);
    }

    @InputFiles
    public FileCollection getSourceFiles() {
        Project project = this.getProject();
        return project.files(new Object[]{this._sourceFiles});
    }

    public void setDestinationFile(Object destinationFile) {
        this._destinationFile = destinationFile;
    }

    public void setSourceFiles(Iterable<Object> sourceFiles) {
        this._sourceFiles.clear();
        this.sourceFiles(sourceFiles);
    }

    public ConcatenateTask sourceFiles(Iterable<Object> ... sourceFiles) {
        GUtil.addToCollection(this._sourceFiles, (Iterable[])sourceFiles);
        return this;
    }

    public ConcatenateTask sourceFiles(Object ... sourceFiles) {
        return this.sourceFiles(Arrays.asList(sourceFiles));
    }
}

