/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.util;

import com.liferay.gradle.util.ArrayUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

public class GradleUtil {
    public static Configuration addConfiguration(Project project, String name) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        return (Configuration)configurationContainer.create(name);
    }

    public static Dependency addDependency(Project project, String configurationName, File file) {
        return GradleUtil._addDependency(project, configurationName, project.files(new Object[]{file}));
    }

    public static Dependency addDependency(Project project, String configurationName, FileCollection fileCollection) {
        return GradleUtil._addDependency(project, configurationName, fileCollection);
    }

    public static Dependency addDependency(Project project, String configurationName, String dependencyNotation) {
        return GradleUtil._addDependency(project, configurationName, dependencyNotation);
    }

    public static Dependency addDependency(Project project, String configurationName, String group, String name, String version) {
        return GradleUtil.addDependency(project, configurationName, group, name, version, true);
    }

    public static Dependency addDependency(Project project, String configurationName, String group, String name, String version, boolean transitive) {
        return GradleUtil.addDependency(project, configurationName, group, name, version, null, transitive);
    }

    public static Dependency addDependency(Project project, String configurationName, String group, String name, String version, String classifier, boolean transitive) {
        HashMap<String, Object> dependencyNotation = new HashMap<String, Object>();
        if (Validator.isNotNull(classifier)) {
            dependencyNotation.put("classifier", classifier);
        }
        dependencyNotation.put("group", group);
        dependencyNotation.put("name", name);
        dependencyNotation.put("transitive", transitive);
        dependencyNotation.put("version", version);
        return GradleUtil._addDependency(project, configurationName, dependencyNotation);
    }

    public static <T> T addExtension(ExtensionAware extensionAware, String name, Class<T> clazz) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        return (T)extensionContainer.create(name, clazz, new Object[]{extensionAware});
    }

    public static SourceSet addSourceSet(Project project, String name) {
        JavaPluginConvention javaPluginConvention = GradleUtil.getConvention(project, JavaPluginConvention.class);
        SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
        return (SourceSet)sourceSetContainer.create(name);
    }

    public static <T extends Task> T addTask(Project project, String name, Class<T> clazz) {
        Map<String, Class<T>> args = Collections.singletonMap("type", clazz);
        return (T)project.task(args, name);
    }

    public static <T extends Plugin<? extends Project>> void applyPlugin(Project project, Class<T> clazz) {
        Map<String, Class<T>> args = Collections.singletonMap("plugin", clazz);
        project.apply(args);
    }

    public static void applyScript(Project project, String name, Object object) {
        ClassLoader classLoader = GradleUtil.class.getClassLoader();
        URL url = classLoader.getResource(name);
        if (url == null) {
            throw new GradleException("Unable to apply script " + name);
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("from", url);
        if (object != null) {
            args.put("to", object);
        }
        project.apply(args);
    }

    public static void executeIfEmpty(final Configuration configuration, final Action<Configuration> action) {
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        resolvableDependencies.beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                DependencySet dependencies = configuration.getDependencies();
                Set parentConfigurations = configuration.getExtendsFrom();
                if (dependencies.isEmpty() && parentConfigurations.isEmpty()) {
                    action.execute((Object)configuration);
                }
            }
        });
    }

    public static Configuration getConfiguration(Project project, String name) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        return configurationContainer.getByName(name);
    }

    public static <T> T getConvention(Project project, Class<T> clazz) {
        Convention convention = project.getConvention();
        return (T)convention.getPlugin(clazz);
    }

    public static <T> T getExtension(ExtensionAware extensionAware, Class<T> clazz) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        return (T)extensionContainer.getByType(clazz);
    }

    public static FileTree getFilteredFileTree(FileTree fileTree, String[] excludes, String[] includes) {
        PatternSet patternFilterable = new PatternSet();
        if (ArrayUtil.isNotEmpty(excludes)) {
            patternFilterable.setExcludes(Arrays.asList(excludes));
        }
        if (ArrayUtil.isNotEmpty(includes)) {
            patternFilterable.setIncludes(Arrays.asList(includes));
        }
        return fileTree.matching((PatternFilterable)patternFilterable);
    }

    public static Properties getGradleProperties(File gradlePropertiesDir) {
        File gradlePropertiesFile = new File(gradlePropertiesDir, "gradle.properties");
        if (!gradlePropertiesFile.exists()) {
            return null;
        }
        Properties properties = GUtil.loadProperties((File)gradlePropertiesFile);
        File gradleExtPropertiesFile = new File(gradlePropertiesFile.getParentFile(), "gradle-ext.properties");
        if (gradleExtPropertiesFile.exists()) {
            properties.putAll((Map<?, ?>)GUtil.loadProperties((File)gradleExtPropertiesFile));
        }
        return properties;
    }

    public static Properties getGradleProperties(Project project) {
        return GradleUtil.getGradleProperties(GradleUtil.getRootDir(project, "gradle.properties"));
    }

    public static String getGradlePropertiesValue(File gradlePropertiesDir, String key) {
        return GradleUtil.getGradlePropertiesValue(gradlePropertiesDir, key, "");
    }

    public static String getGradlePropertiesValue(File gradlePropertiesDir, String key, String defaultValue) {
        if (gradlePropertiesDir == null) {
            return defaultValue;
        }
        Properties properties = GradleUtil.getGradleProperties(gradlePropertiesDir);
        return properties.getProperty(key, defaultValue);
    }

    public static String getGradlePropertiesValue(Project project, String key) {
        return GradleUtil.getGradlePropertiesValue(project, key, "");
    }

    public static String getGradlePropertiesValue(Project project, String key, String defaultValue) {
        File rootDir = GradleUtil.getRootDir(project, "gradle.properties");
        return GradleUtil.getGradlePropertiesValue(rootDir, key, defaultValue);
    }

    public static Project getProject(Project rootProject, File projectDir) {
        for (Project project : rootProject.getAllprojects()) {
            if (!projectDir.equals(project.getProjectDir())) continue;
            return project;
        }
        return null;
    }

    public static Object getProperty(ExtensionAware extensionAware, String name) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
        if (!extraPropertiesExtension.has(name)) {
            return null;
        }
        Object value = extraPropertiesExtension.get(name);
        if (value instanceof String && Validator.isNull((String)value)) {
            value = null;
        }
        return value;
    }

    public static boolean getProperty(ExtensionAware extensionAware, String name, boolean defaultValue) {
        Object value = GradleUtil.getProperty(extensionAware, name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static String getProperty(ExtensionAware extensionAware, String name, String defaultValue) {
        Object value = GradleUtil.getProperty(extensionAware, name);
        if (value == null) {
            return defaultValue;
        }
        return GradleUtil.toString(value);
    }

    public static File getProperty(Project project, String name, File defaultValue) {
        Object value = GradleUtil.getProperty((ExtensionAware)project, name);
        if (value == null) {
            return defaultValue;
        }
        return GradleUtil.toFile(project, value);
    }

    public static File getRootDir(File dir, String markerFileName) {
        do {
            File markerFile;
            if (!(markerFile = new File(dir, markerFileName)).exists()) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    public static File getRootDir(Project project, String markerFileName) {
        return GradleUtil.getRootDir(project.getProjectDir(), markerFileName);
    }

    public static SourceSet getSourceSet(Project project, String name) {
        JavaPluginConvention javaPluginConvention = GradleUtil.getConvention(project, JavaPluginConvention.class);
        SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
        return (SourceSet)sourceSetContainer.getByName(name);
    }

    public static Task getTask(Project project, String name) {
        TaskContainer taskContainer = project.getTasks();
        return taskContainer.getByName(name);
    }

    public static String getTaskName(String prefix, File file) {
        String fileName = FileUtil.stripExtension(file.getName());
        fileName = fileName.replaceAll("\\W", "");
        return prefix + StringUtil.capitalize(fileName);
    }

    public static String getTaskPrefixedProperty(Task task, String name) {
        String suffix = "." + name;
        String value = System.getProperty(task.getPath() + suffix);
        if (Validator.isNull(value)) {
            value = System.getProperty(task.getName() + suffix);
        }
        return value;
    }

    public static void removeDependencies(Project project, String configurationName, String[] dependencyNotations) {
        Configuration configuration = GradleUtil.getConfiguration(project, configurationName);
        DependencySet dependencies = configuration.getDependencies();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            String dependencyNotation = GradleUtil._getDependencyNotation(dependency);
            if (!ArrayUtil.contains(dependencyNotations, dependencyNotation)) continue;
            iterator.remove();
        }
    }

    public static void setProperty(ExtensionAware extensionAware, String name, Object value) {
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
        extraPropertiesExtension.set(name, value);
    }

    public static File toFile(Project project, Object object) {
        if (object == null) {
            return null;
        }
        return project.file(object);
    }

    public static Integer toInteger(Object object) {
        if ((object = GradleUtil.toObject(object)) instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        return null;
    }

    public static Object toObject(Object object) {
        if (object instanceof Callable) {
            Callable callable = (Callable)object;
            try {
                object = callable.call();
            }
            catch (Exception exception) {
                throw new GradleException(exception.getMessage(), (Throwable)exception);
            }
        } else if (object instanceof Closure) {
            Closure closure = (Closure)object;
            object = closure.call();
        }
        return object;
    }

    public static String toString(Object object) {
        if ((object = GradleUtil.toObject(object)) == null) {
            return null;
        }
        return object.toString();
    }

    public static List<String> toStringList(Iterable<?> iterable) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object object : iterable) {
            list.add(GradleUtil.toString(object));
        }
        return list;
    }

    public static boolean waitFor(Callable<Boolean> callable, long checkInterval, long timeout) throws Exception {
        long end = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end) {
            if (callable.call().booleanValue()) {
                return true;
            }
            Thread.sleep(checkInterval);
        }
        return false;
    }

    private static Dependency _addDependency(Project project, String configurationName, Object dependencyNotation) {
        DependencyHandler dependencyHandler = project.getDependencies();
        return dependencyHandler.add(configurationName, dependencyNotation);
    }

    private static String _getDependencyNotation(Dependency dependency) {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull(dependency.getGroup())) {
            sb.append(dependency.getGroup());
            sb.append(":");
        }
        sb.append(dependency.getName());
        if (Validator.isNotNull(dependency.getVersion())) {
            sb.append(":");
            sb.append(dependency.getVersion());
        }
        return sb.toString();
    }
}

