/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.address.internal.resource.v1_0;

import com.liferay.headless.admin.address.dto.v1_0.Country;
import com.liferay.headless.admin.address.resource.v1_0.CountryResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseCountryResourceImpl
implements CountryResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<Country> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<Country>, UnsafeConsumer<Country, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseCountryResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="active"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Country")})
    @GET
    @Path(value="/countries")
    @Produces(value={"application/json", "application/xml"})
    public Page<Country> getCountriesPage(@Parameter(hidden=true) @QueryParam(value="active") Boolean active, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Tags(value={@Tag(name="Country")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/countries")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Country postCountry(Country country) throws Exception {
        return new Country();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Country")})
    @Consumes(value={"application/json"})
    @Path(value="/countries/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postCountryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Country.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="a2")})
    @Tags(value={@Tag(name="Country")})
    @GET
    @Path(value="/countries/by-a2/{a2}")
    @Produces(value={"application/json", "application/xml"})
    public Country getCountryByA2(@Parameter(hidden=true) @NotNull @PathParam(value="a2") String a2) throws Exception {
        return new Country();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="a3")})
    @Tags(value={@Tag(name="Country")})
    @GET
    @Path(value="/countries/by-a3/{a3}")
    @Produces(value={"application/json", "application/xml"})
    public Country getCountryByA3(@Parameter(hidden=true) @NotNull @PathParam(value="a3") String a3) throws Exception {
        return new Country();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="name")})
    @Tags(value={@Tag(name="Country")})
    @GET
    @Path(value="/countries/by-name/{name}")
    @Produces(value={"application/json", "application/xml"})
    public Country getCountryByName(@Parameter(hidden=true) @NotNull @PathParam(value="name") String name) throws Exception {
        return new Country();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="number")})
    @Tags(value={@Tag(name="Country")})
    @GET
    @Path(value="/countries/by-number/{number}")
    @Produces(value={"application/json", "application/xml"})
    public Country getCountryByNumber(@Parameter(hidden=true) @NotNull @PathParam(value="number") Integer number) throws Exception {
        return new Country();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="countryId")})
    @Tags(value={@Tag(name="Country")})
    @DELETE
    @Path(value="/countries/{countryId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteCountry(@Parameter(hidden=true) @NotNull @PathParam(value="countryId") Long countryId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Country")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/countries/batch")
    @Produces(value={"application/json"})
    public Response deleteCountryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Country.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="countryId")})
    @Tags(value={@Tag(name="Country")})
    @GET
    @Path(value="/countries/{countryId}")
    @Produces(value={"application/json", "application/xml"})
    public Country getCountry(@Parameter(hidden=true) @NotNull @PathParam(value="countryId") Long countryId) throws Exception {
        return new Country();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="countryId")})
    @Tags(value={@Tag(name="Country")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/countries/{countryId}")
    @Produces(value={"application/json", "application/xml"})
    public Country patchCountry(@Parameter(hidden=true) @NotNull @PathParam(value="countryId") Long countryId, Country country) throws Exception {
        Country existingCountry = this.getCountry(countryId);
        if (country.getA2() != null) {
            existingCountry.setA2(country.getA2());
        }
        if (country.getA3() != null) {
            existingCountry.setA3(country.getA3());
        }
        if (country.getActive() != null) {
            existingCountry.setActive(country.getActive());
        }
        if (country.getBillingAllowed() != null) {
            existingCountry.setBillingAllowed(country.getBillingAllowed());
        }
        if (country.getGroupFilterEnabled() != null) {
            existingCountry.setGroupFilterEnabled(country.getGroupFilterEnabled());
        }
        if (country.getIdd() != null) {
            existingCountry.setIdd(country.getIdd());
        }
        if (country.getName() != null) {
            existingCountry.setName(country.getName());
        }
        if (country.getNumber() != null) {
            existingCountry.setNumber(country.getNumber());
        }
        if (country.getPosition() != null) {
            existingCountry.setPosition(country.getPosition());
        }
        if (country.getShippingAllowed() != null) {
            existingCountry.setShippingAllowed(country.getShippingAllowed());
        }
        if (country.getSubjectToVAT() != null) {
            existingCountry.setSubjectToVAT(country.getSubjectToVAT());
        }
        if (country.getTitle_i18n() != null) {
            existingCountry.setTitle_i18n(country.getTitle_i18n());
        }
        if (country.getZipRequired() != null) {
            existingCountry.setZipRequired(country.getZipRequired());
        }
        this.preparePatch(country, existingCountry);
        return this.putCountry(countryId, existingCountry);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="countryId")})
    @Tags(value={@Tag(name="Country")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/countries/{countryId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Country putCountry(@Parameter(hidden=true) @NotNull @PathParam(value="countryId") Long countryId, Country country) throws Exception {
        return new Country();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Country")})
    @Consumes(value={"application/json"})
    @Path(value="/countries/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putCountryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(Country.class.getName(), callbackURL, object)).build();
    }

    public void create(Collection<Country> countries, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer countryUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            countryUnsafeConsumer = country -> this.postCountry((Country)country);
        }
        if (countryUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for Country");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(countries, (Object)countryUnsafeConsumer);
        } else {
            for (Country country2 : countries) {
                countryUnsafeConsumer.accept((Object)country2);
            }
        }
    }

    public void delete(Collection<Country> countries, Map<String, Serializable> parameters) throws Exception {
        for (Country country : countries) {
            this.deleteCountry(country.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<Country> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Country> countries, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer countryUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            countryUnsafeConsumer = country -> this.patchCountry(country.getId() != null ? country.getId() : Long.parseLong((String)parameters.get("countryId")), (Country)country);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            countryUnsafeConsumer = country -> this.putCountry(country.getId() != null ? country.getId() : Long.parseLong((String)parameters.get("countryId")), (Country)country);
        }
        if (countryUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for Country");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(countries, (Object)countryUnsafeConsumer);
        } else {
            for (Country country2 : countries) {
                countryUnsafeConsumer.accept((Object)country2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<Country>, UnsafeConsumer<Country, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(Country country, Country existingCountry) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

