/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.internal.dto.v1_0.util;

import com.liferay.headless.admin.content.dto.v1_0.ContentAssociation;
import com.liferay.headless.admin.content.dto.v1_0.DisplayPageTemplateSettings;
import com.liferay.headless.admin.content.dto.v1_0.OpenGraphSettingsMapping;
import com.liferay.headless.admin.content.dto.v1_0.SEOSettingsMapping;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;

public class DisplayPageTemplateSettingsUtil {
    private static final Map<String, String> _contentTypes = HashMapBuilder.put((Object)"com.liferay.blogs.model.BlogsEntry", (Object)"BlogPosting").put((Object)"com.liferay.document.library.kernel.model.DLFileEntry", (Object)"Document").put((Object)"com.liferay.journal.model.JournalArticle", (Object)"StructuredContent").put((Object)"com.liferay.portal.kernel.repository.model.FileEntry", (Object)"Document").build();

    public static DisplayPageTemplateSettings getDisplayPageTemplateSettings(final DTOConverterContext dtoConverterContext, final InfoItemServiceTracker infoItemServiceTracker, final Layout layout, final LayoutPageTemplateEntry layoutPageTemplateEntry, final Portal portal) {
        return new DisplayPageTemplateSettings(){
            {
                this.contentAssociation = DisplayPageTemplateSettingsUtil._getContentAssociation(dtoConverterContext, infoItemServiceTracker, layoutPageTemplateEntry, portal);
                this.openGraphSettingsMapping = DisplayPageTemplateSettingsUtil._getOpenGraphSettingsMapping(layout);
                this.seoSettingsMapping = DisplayPageTemplateSettingsUtil._getSEOSettingsMapping(dtoConverterContext, layout);
            }
        };
    }

    private static ContentAssociation _getContentAssociation(final DTOConverterContext dtoConverterContext, final InfoItemServiceTracker infoItemServiceTracker, final LayoutPageTemplateEntry layoutPageTemplateEntry, Portal portal) {
        final String className = portal.getClassName(layoutPageTemplateEntry.getClassNameId());
        return new ContentAssociation(){
            {
                this.contentSubtype = DisplayPageTemplateSettingsUtil._getContentSubtype(dtoConverterContext, infoItemServiceTracker, layoutPageTemplateEntry);
                this.contentType = _contentTypes.getOrDefault(className, className);
            }
        };
    }

    private static String _getContentSubtype(DTOConverterContext dtoConverterContext, InfoItemServiceTracker infoItemServiceTracker, LayoutPageTemplateEntry layoutPageTemplateEntry) {
        InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)infoItemServiceTracker.getFirstInfoItemService(InfoItemFormVariationsProvider.class, layoutPageTemplateEntry.getClassName());
        if (infoItemFormVariationsProvider == null) {
            return null;
        }
        InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariation(layoutPageTemplateEntry.getGroupId(), String.valueOf(layoutPageTemplateEntry.getClassTypeId()));
        if (infoItemFormVariation != null) {
            return infoItemFormVariation.getLabel(dtoConverterContext.getLocale());
        }
        return null;
    }

    private static OpenGraphSettingsMapping _getOpenGraphSettingsMapping(final Layout layout) {
        return new OpenGraphSettingsMapping(){
            {
                this.descriptionMappingFieldKey = layout.getTypeSettingsProperty("mapped-openGraphDescription", "description");
                this.imageAltMappingFieldKey = layout.getTypeSettingsProperty("mapped-openGraphImageAlt", null);
                this.imageMappingFieldKey = layout.getTypeSettingsProperty("mapped-openGraphImage", null);
                this.titleMappingFieldKey = layout.getTypeSettingsProperty("mapped-openGraphTitle", "title");
            }
        };
    }

    private static SEOSettingsMapping _getSEOSettingsMapping(final DTOConverterContext dtoConverterContext, final Layout layout) {
        return new SEOSettingsMapping(){
            {
                this.descriptionMappingFieldKey = layout.getTypeSettingsProperty("mapped-description", "description");
                this.htmlTitleMappingFieldKey = layout.getTypeSettingsProperty("mapped-title", "title");
                this.robots = layout.getRobots(dtoConverterContext.getLocale());
                this.robots_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getRobotsMap());
            }
        };
    }
}

