/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.internal.resource.v1_0;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.headless.admin.content.internal.resource.v1_0.BasePageDefinitionResourceImpl;
import com.liferay.headless.admin.content.resource.v1_0.PageDefinitionResource;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.layout.page.template.importer.LayoutPageTemplatesImporter;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.taglib.util.ThemeUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/page-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={PageDefinitionResource.class})
public class PageDefinitionResourceImpl
extends BasePageDefinitionResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(PageDefinitionResourceImpl.class);
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference(target="(resource.name=com.liferay.fragment)")
    private PortletResourcePermission _fragmentPortletResourcePermission;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference(target="(resource.name=com.liferay.layout.page.template)")
    private PortletResourcePermission _layoutPageTemplatePortletResourcePermission;
    @Reference
    private LayoutPageTemplatesImporter _layoutPageTemplatesImporter;
    @Reference
    private LayoutPermission _layoutPermission;
    @Reference
    private Portal _portal;
    @Context
    private Providers _providers;

    @Override
    public Response postSitePageDefinitionPreview(Long siteId, PageDefinition pageDefinition) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this.contextUser);
        if (!(this._fragmentPortletResourcePermission.contains(permissionChecker, siteId.longValue(), "MANAGE_FRAGMENT_ENTRIES") || this._layoutPageTemplatePortletResourcePermission.contains(permissionChecker, siteId.longValue(), "ADD_LAYOUT_PAGE_TEMPLATE_ENTRY") || this._layoutPermission.contains(permissionChecker, siteId.longValue(), false, 0L, "ADD_LAYOUT"))) {
            throw new NotAuthorizedException(Response.noContent().build());
        }
        Map<Locale, String> nameMap = Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), StringUtil.randomId());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest);
        Layout layout = this._layoutLocalService.addLayout(this.contextUser.getUserId(), siteId.longValue(), false, 0L, this._portal.getClassNameId(PageDefinition.class), 0L, nameMap, nameMap, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "content", "", true, false, Collections.emptyMap(), 0L, serviceContext);
        LayoutStructure layoutStructure = new LayoutStructure();
        layoutStructure.addRootLayoutStructureItem();
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(siteId.longValue(), layout.getPlid());
        ContextResolver contextResolver = this._providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE);
        ObjectMapper objectMapper = (ObjectMapper)contextResolver.getContext(ObjectMapper.class);
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider();
        SimpleFilterProvider filterProvider = simpleFilterProvider.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
        ObjectWriter objectWriter = objectMapper.writer((FilterProvider)filterProvider);
        try {
            this._layoutPageTemplatesImporter.importPageElement(layout, layoutStructure, layoutStructure.getMainItemId(), objectWriter.writeValueAsString((Object)pageDefinition.getPageElement()), 0);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to import page element", (Throwable)exception);
            }
            return Response.serverError().status(500).entity((Object)"Unable to post page definition preview").build();
        }
        this.contextHttpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)this.contextHttpServletRequest, (String)("p_l_id=" + layout.getPlid()), (boolean)false);
        this.contextHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)this._getThemeDisplay(layout));
        layout.includeLayoutContent(this.contextHttpServletRequest, this.contextHttpServletResponse);
        StringBundler sb = (StringBundler)this.contextHttpServletRequest.getAttribute("LAYOUT_CONTENT");
        if (sb == null) {
            return Response.noContent().build();
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        ServletContext servletContext = ServletContextPool.get((String)"");
        if (this.contextHttpServletRequest.getAttribute("CTX") == null) {
            this.contextHttpServletRequest.setAttribute("CTX", (Object)servletContext);
        }
        Document document = Jsoup.parse((String)ThemeUtil.include((ServletContext)servletContext, (HttpServletRequest)this.contextHttpServletRequest, (HttpServletResponse)this.contextHttpServletResponse, (String)"portal_normal.ftl", (Theme)layoutSet.getTheme(), (boolean)false));
        this._layoutLocalService.deleteLayout(layout.getPlid(), serviceContext);
        Element bodyElement = document.body();
        bodyElement.html(sb.toString());
        return Response.ok((Object)document.html()).build();
    }

    private ThemeDisplay _getThemeDisplay(Layout layout) throws Exception {
        ServicePreAction servicePreAction = new ServicePreAction();
        DummyHttpServletResponse httpServletResponse = new DummyHttpServletResponse();
        servicePreAction.servicePre(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setLayout(layout);
        themeDisplay.setScopeGroupId(layout.getGroupId());
        themeDisplay.setSiteGroupId(layout.getGroupId());
        return themeDisplay;
    }
}

