/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.content.internal.resource.v1_0;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.headless.admin.content.internal.dto.v1_0.extension.ExtensionStructuredContent;
import com.liferay.headless.admin.content.internal.dto.v1_0.util.VersionUtil;
import com.liferay.headless.admin.content.internal.odata.entity.v1_0.StructuredContentEntityModel;
import com.liferay.headless.admin.content.internal.resource.v1_0.BaseStructuredContentResourceImpl;
import com.liferay.headless.admin.content.resource.v1_0.StructuredContentResource;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.headless.delivery.dto.v1_0.util.StructuredContentUtil;
import com.liferay.headless.delivery.dynamic.data.mapping.DDMFormFieldUtil;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.EntityExtensionUtil;
import com.liferay.portal.vulcan.util.LocalDateTimeUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/structured-content.properties"}, scope=ServiceScope.PROTOTYPE, service={StructuredContentResource.class})
public class StructuredContentResourceImpl
extends BaseStructuredContentResourceImpl
implements EntityModelResource {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormValuesValidator _ddmFormValuesValidator;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    private final EntityModel _entityModel = new StructuredContentEntityModel();
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalConverter _journalConverter;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;

    @Override
    public void deleteStructuredContentByVersion(Long structuredContentId, Double version) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticle(structuredContentId.longValue(), -1, false);
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), version.doubleValue(), journalArticle.getUrlTitle(), new ServiceContext());
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return this._entityModel;
    }

    @Override
    public Page<StructuredContent> getSiteStructuredContentsPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        boolean permissionToManageVersions = this._hasPermission(siteId);
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getSiteStructuredContentsPage", "com.liferay.journal", siteId)).build(), booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(0L)), BooleanClauseOccur.MUST);
            }
        }, (Filter)filter, (String)JournalArticle.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"articleId", "scopeGroupId", "rootEntryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            if (permissionToManageVersions) {
                searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
                searchContext.setAttribute("latest", (Serializable)Boolean.TRUE);
            } else {
                searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
                searchContext.setAttribute("head", (Serializable)Boolean.TRUE);
            }
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, document -> {
            JournalArticle journalArticle = permissionToManageVersions ? this._journalArticleLocalService.getLatestArticle(GetterUtil.getLong((String)document.get("rootEntryClassPK")), -1, false) : this._journalArticleLocalService.getLatestArticle(GetterUtil.getLong((String)document.get("rootEntryClassPK")), 0, true);
            return this._toExtensionStructuredContent(journalArticle);
        });
    }

    @Override
    public StructuredContent getStructuredContentByVersion(Long structuredContentId, Double version) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticle(structuredContentId.longValue(), -1, false);
        return this._toExtensionStructuredContent(this._journalArticleService.getArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), version.doubleValue()));
    }

    @Override
    public Page<StructuredContent> getStructuredContentsVersionsPage(Long structuredContentId) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticle(structuredContentId.longValue(), -1, false);
        if (this._hasPermission(journalArticle.getGroupId())) {
            return Page.of(this.transform(this._journalArticleService.getArticlesByArticleId(journalArticle.getGroupId(), journalArticle.getArticleId(), -1, -1, null), this::_toExtensionStructuredContent));
        }
        return Page.of(this.transform(this._journalArticleService.search(journalArticle.getCompanyId(), journalArticle.getGroupId(), Collections.singletonList(journalArticle.getFolderId()), journalArticle.getClassNameId(), journalArticle.getArticleId(), null, null, null, null, (String)null, null, null, null, null, 0, true, -1, -1, null), this::_toExtensionStructuredContent));
    }

    @Override
    public StructuredContent postSiteStructuredContentDraft(Long siteId, StructuredContent structuredContent) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureService.getStructure(structuredContent.getContentStructureId().longValue());
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getTitle(), (Map)structuredContent.getTitle_i18n());
        Map descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getDescription(), (Map)structuredContent.getDescription_i18n());
        HashSet notFoundLocales = new HashSet(descriptionMap.keySet());
        Map friendlyUrlMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getFriendlyUrlPath(), (Map)structuredContent.getFriendlyUrlPath_i18n(), (Map)titleMap);
        notFoundLocales.addAll(friendlyUrlMap.keySet());
        LocalizedMapUtil.validateI18n((boolean)true, (Locale)LocaleUtil.getSiteDefault(), (String)"Structured content", (Map)titleMap, notFoundLocales);
        this._validateContentFields(structuredContent.getContentFields(), ddmStructure);
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)structuredContent.getDatePublished());
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((Long[])structuredContent.getTaxonomyCategoryIds(), (String[])structuredContent.getKeywords(), this._getExpandoBridgeAttributes(structuredContent), (Long)siteId, (HttpServletRequest)this.contextHttpServletRequest, (String)structuredContent.getViewableByAsString());
        serviceContext.setWorkflowAction(2);
        return this._toExtensionStructuredContent(this._journalArticleService.addArticle(null, siteId.longValue(), 0L, 0L, 0L, null, true, titleMap, descriptionMap, friendlyUrlMap, StructuredContentUtil.getJournalArticleContent((DDM)this._ddm, (DDMFormValues)DDMFormValuesUtil.toDDMFormValues((ContentField[])structuredContent.getContentFields(), (DDMForm)ddmStructure.getDDMForm(), (DLAppService)this._dlAppService, (long)siteId, (JournalArticleService)this._journalArticleService, (LayoutLocalService)this._layoutLocalService, (Locale)this.contextAcceptLanguage.getPreferredLocale(), this._getRootDDMFormFields(ddmStructure)), (DDMFormValuesSerializer)this._jsonDDMFormValuesSerializer, (DDMFormValuesValidator)this._ddmFormValuesValidator, (DDMStructure)ddmStructure, (JournalConverter)this._journalConverter), ddmStructure.getStructureKey(), this._getDDMTemplateKey(ddmStructure), null, localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext));
    }

    private String _getDDMTemplateKey(DDMStructure ddmStructure) {
        List ddmTemplates = ddmStructure.getTemplates();
        if (ddmTemplates.isEmpty()) {
            return "";
        }
        DDMTemplate ddmTemplate = (DDMTemplate)ddmTemplates.get(0);
        return ddmTemplate.getTemplateKey();
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(StructuredContent structuredContent) {
        return CustomFieldsUtil.toMap((String)JournalArticle.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])structuredContent.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale());
    }

    private List<DDMFormField> _getRootDDMFormFields(DDMStructure ddmStructure) {
        return TransformUtil.transform((Collection)ddmStructure.getRootFieldNames(), fieldName -> DDMFormFieldUtil.getDDMFormField((DDMStructureService)this._ddmStructureService, (DDMStructure)ddmStructure, (String)fieldName));
    }

    private boolean _hasPermission(Long siteId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.hasPermission(siteId.longValue(), "com_liferay_journal_web_portlet_JournalPortlet", 0L, "ACCESS_IN_CONTROL_PANEL");
    }

    private StructuredContent _toExtensionStructuredContent(JournalArticle journalArticle) throws Exception {
        DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(JournalArticle.class.getName());
        if (dtoConverter == null) {
            return null;
        }
        StructuredContent structuredContent = (StructuredContent)dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), Collections.emptyMap(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)journalArticle.getResourcePrimKey(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)journalArticle);
        return (StructuredContent)EntityExtensionUtil.extend((Object)structuredContent, StructuredContent.class, ExtensionStructuredContent.class, ExtensionStructuredContent2 -> ExtensionStructuredContent2.setVersion(VersionUtil.toVersion(this.contextAcceptLanguage, journalArticle)));
    }

    private void _validateContentFields(ContentField[] contentFields, DDMStructure ddmStructure) {
        if (ArrayUtil.isEmpty((Object[])contentFields)) {
            return;
        }
        for (ContentField contentField : contentFields) {
            DDMFormField ddmFormField = DDMFormFieldUtil.getDDMFormField((DDMStructureService)this._ddmStructureService, (DDMStructure)ddmStructure, (String)contentField.getName());
            if (ddmFormField == null) {
                throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to get content field value for \"", contentField.getName(), "\" for content structure ", ddmStructure.getStructureId()}));
            }
            this._validateContentFields(contentField.getNestedContentFields(), ddmStructure);
        }
    }
}

