/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.client.serdes.v1_0;

import com.liferay.headless.admin.taxonomy.client.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.client.json.BaseJSONParser;
import com.liferay.headless.admin.taxonomy.client.serdes.v1_0.CreatorSerDes;
import com.liferay.headless.admin.taxonomy.client.serdes.v1_0.ParentTaxonomyCategorySerDes;
import com.liferay.headless.admin.taxonomy.client.serdes.v1_0.ParentTaxonomyVocabularySerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class TaxonomyCategorySerDes {
    public static TaxonomyCategory toDTO(String json) {
        TaxonomyCategoryJSONParser taxonomyCategoryJSONParser = new TaxonomyCategoryJSONParser();
        return (TaxonomyCategory)taxonomyCategoryJSONParser.parseToDTO(json);
    }

    public static TaxonomyCategory[] toDTOs(String json) {
        TaxonomyCategoryJSONParser taxonomyCategoryJSONParser = new TaxonomyCategoryJSONParser();
        return (TaxonomyCategory[])taxonomyCategoryJSONParser.parseToDTOs(json);
    }

    public static String toJSON(TaxonomyCategory taxonomyCategory) {
        if (taxonomyCategory == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (taxonomyCategory.getActions() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(TaxonomyCategorySerDes._toJSON(taxonomyCategory.getActions()));
        }
        if (taxonomyCategory.getAvailableLanguages() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availableLanguages\": ");
            sb.append("[");
            for (int i = 0; i < taxonomyCategory.getAvailableLanguages().length; ++i) {
                sb.append("\"");
                sb.append(TaxonomyCategorySerDes._escape(taxonomyCategory.getAvailableLanguages()[i]));
                sb.append("\"");
                if (i + 1 >= taxonomyCategory.getAvailableLanguages().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (taxonomyCategory.getCreator() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(taxonomyCategory.getCreator()));
        }
        if (taxonomyCategory.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(taxonomyCategory.getDateCreated()));
            sb.append("\"");
        }
        if (taxonomyCategory.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(taxonomyCategory.getDateModified()));
            sb.append("\"");
        }
        if (taxonomyCategory.getDescription() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(TaxonomyCategorySerDes._escape(taxonomyCategory.getDescription()));
            sb.append("\"");
        }
        if (taxonomyCategory.getDescription_i18n() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description_i18n\": ");
            sb.append(TaxonomyCategorySerDes._toJSON(taxonomyCategory.getDescription_i18n()));
        }
        if (taxonomyCategory.getExternalReferenceCode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(TaxonomyCategorySerDes._escape(taxonomyCategory.getExternalReferenceCode()));
            sb.append("\"");
        }
        if (taxonomyCategory.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append("\"");
            sb.append(TaxonomyCategorySerDes._escape(taxonomyCategory.getId()));
            sb.append("\"");
        }
        if (taxonomyCategory.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(TaxonomyCategorySerDes._escape(taxonomyCategory.getName()));
            sb.append("\"");
        }
        if (taxonomyCategory.getName_i18n() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(TaxonomyCategorySerDes._toJSON(taxonomyCategory.getName_i18n()));
        }
        if (taxonomyCategory.getNumberOfTaxonomyCategories() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfTaxonomyCategories\": ");
            sb.append(taxonomyCategory.getNumberOfTaxonomyCategories());
        }
        if (taxonomyCategory.getParentTaxonomyCategory() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentTaxonomyCategory\": ");
            sb.append(String.valueOf(taxonomyCategory.getParentTaxonomyCategory()));
        }
        if (taxonomyCategory.getParentTaxonomyVocabulary() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentTaxonomyVocabulary\": ");
            sb.append(String.valueOf(taxonomyCategory.getParentTaxonomyVocabulary()));
        }
        if (taxonomyCategory.getTaxonomyCategoryUsageCount() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryUsageCount\": ");
            sb.append(taxonomyCategory.getTaxonomyCategoryUsageCount());
        }
        if (taxonomyCategory.getViewableBy() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)taxonomyCategory.getViewableBy());
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        TaxonomyCategoryJSONParser taxonomyCategoryJSONParser = new TaxonomyCategoryJSONParser();
        return taxonomyCategoryJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(TaxonomyCategory taxonomyCategory) {
        if (taxonomyCategory == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (taxonomyCategory.getActions() == null) {
            map.put("actions", null);
        } else {
            map.put("actions", String.valueOf(taxonomyCategory.getActions()));
        }
        if (taxonomyCategory.getAvailableLanguages() == null) {
            map.put("availableLanguages", null);
        } else {
            map.put("availableLanguages", String.valueOf(taxonomyCategory.getAvailableLanguages()));
        }
        if (taxonomyCategory.getCreator() == null) {
            map.put("creator", null);
        } else {
            map.put("creator", String.valueOf(taxonomyCategory.getCreator()));
        }
        if (taxonomyCategory.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(taxonomyCategory.getDateCreated()));
        }
        if (taxonomyCategory.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(taxonomyCategory.getDateModified()));
        }
        if (taxonomyCategory.getDescription() == null) {
            map.put("description", null);
        } else {
            map.put("description", String.valueOf(taxonomyCategory.getDescription()));
        }
        if (taxonomyCategory.getDescription_i18n() == null) {
            map.put("description_i18n", null);
        } else {
            map.put("description_i18n", String.valueOf(taxonomyCategory.getDescription_i18n()));
        }
        if (taxonomyCategory.getExternalReferenceCode() == null) {
            map.put("externalReferenceCode", null);
        } else {
            map.put("externalReferenceCode", String.valueOf(taxonomyCategory.getExternalReferenceCode()));
        }
        if (taxonomyCategory.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(taxonomyCategory.getId()));
        }
        if (taxonomyCategory.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(taxonomyCategory.getName()));
        }
        if (taxonomyCategory.getName_i18n() == null) {
            map.put("name_i18n", null);
        } else {
            map.put("name_i18n", String.valueOf(taxonomyCategory.getName_i18n()));
        }
        if (taxonomyCategory.getNumberOfTaxonomyCategories() == null) {
            map.put("numberOfTaxonomyCategories", null);
        } else {
            map.put("numberOfTaxonomyCategories", String.valueOf(taxonomyCategory.getNumberOfTaxonomyCategories()));
        }
        if (taxonomyCategory.getParentTaxonomyCategory() == null) {
            map.put("parentTaxonomyCategory", null);
        } else {
            map.put("parentTaxonomyCategory", String.valueOf(taxonomyCategory.getParentTaxonomyCategory()));
        }
        if (taxonomyCategory.getParentTaxonomyVocabulary() == null) {
            map.put("parentTaxonomyVocabulary", null);
        } else {
            map.put("parentTaxonomyVocabulary", String.valueOf(taxonomyCategory.getParentTaxonomyVocabulary()));
        }
        if (taxonomyCategory.getTaxonomyCategoryUsageCount() == null) {
            map.put("taxonomyCategoryUsageCount", null);
        } else {
            map.put("taxonomyCategoryUsageCount", String.valueOf(taxonomyCategory.getTaxonomyCategoryUsageCount()));
        }
        if (taxonomyCategory.getViewableBy() == null) {
            map.put("viewableBy", null);
        } else {
            map.put("viewableBy", String.valueOf((Object)taxonomyCategory.getViewableBy()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(TaxonomyCategorySerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(TaxonomyCategorySerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(TaxonomyCategorySerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class TaxonomyCategoryJSONParser
    extends BaseJSONParser<TaxonomyCategory> {
        @Override
        protected TaxonomyCategory createDTO() {
            return new TaxonomyCategory();
        }

        protected TaxonomyCategory[] createDTOArray(int size) {
            return new TaxonomyCategory[size];
        }

        @Override
        protected void setField(TaxonomyCategory taxonomyCategory, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "actions")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setActions(TaxonomyCategorySerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "availableLanguages")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setAvailableLanguages(this.toStrings((Object[])jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "creator")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setCreator(CreatorSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "description")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setDescription((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "description_i18n")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setDescription_i18n(TaxonomyCategorySerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setId((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setName((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "name_i18n")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setName_i18n(TaxonomyCategorySerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "numberOfTaxonomyCategories")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setNumberOfTaxonomyCategories(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "parentTaxonomyCategory")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setParentTaxonomyCategory(ParentTaxonomyCategorySerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "parentTaxonomyVocabulary")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setParentTaxonomyVocabulary(ParentTaxonomyVocabularySerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "taxonomyCategoryUsageCount")) {
                if (jsonParserFieldValue != null) {
                    taxonomyCategory.setTaxonomyCategoryUsageCount(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "viewableBy") && jsonParserFieldValue != null) {
                taxonomyCategory.setViewableBy(TaxonomyCategory.ViewableBy.create((String)jsonParserFieldValue));
            }
        }
    }
}

