/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.headless.admin.taxonomy.dto.v1_0.ParentTaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.ParentTaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.asset.kernel.model.AssetCategory"}, service={DTOConverter.class, TaxonomyCategoryDTOConverter.class})
public class TaxonomyCategoryDTOConverter
implements DTOConverter<AssetCategory, TaxonomyCategory> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return TaxonomyCategory.class.getSimpleName();
    }

    public TaxonomyCategory toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategory(((Long)dtoConverterContext.getId()).longValue());
        return this._toTaxonomyCategory(dtoConverterContext, assetCategory);
    }

    public TaxonomyCategory toDTO(DTOConverterContext dtoConverterContext, AssetCategory assetCategory) throws Exception {
        return this._toTaxonomyCategory(dtoConverterContext, assetCategory);
    }

    private ParentTaxonomyCategory _toParentTaxonomyCategory(final AssetCategory parentAssetCategory, final DTOConverterContext dtoConverterContext) {
        return new ParentTaxonomyCategory(){
            {
                this.id = parentAssetCategory.getCategoryId();
                this.name = parentAssetCategory.getTitle(dtoConverterContext.getLocale());
            }
        };
    }

    private TaxonomyCategory _toTaxonomyCategory(final DTOConverterContext dtoConverterContext, final AssetCategory assetCategory) throws Exception {
        return new TaxonomyCategory(){
            {
                this.actions = dtoConverterContext.getActions();
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])assetCategory.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(TaxonomyCategoryDTOConverter.this._portal, TaxonomyCategoryDTOConverter.this._userLocalService.fetchUser(assetCategory.getUserId()));
                this.dateCreated = assetCategory.getCreateDate();
                this.dateModified = assetCategory.getModifiedDate();
                this.description = assetCategory.getDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)assetCategory.getDescriptionMap());
                this.externalReferenceCode = assetCategory.getExternalReferenceCode();
                this.id = String.valueOf(assetCategory.getCategoryId());
                this.name = assetCategory.getTitle(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)assetCategory.getTitleMap());
                this.numberOfTaxonomyCategories = TaxonomyCategoryDTOConverter.this._assetCategoryService.getChildCategoriesCount(assetCategory.getCategoryId());
                this.parentTaxonomyVocabulary = new ParentTaxonomyVocabulary(){
                    {
                        this.id = assetCategory.getVocabularyId();
                        this.setName(() -> {
                            if (assetCategory.getVocabularyId() == 0L) {
                                return null;
                            }
                            AssetVocabulary assetVocabulary = TaxonomyCategoryDTOConverter.this._assetVocabularyService.getVocabulary(assetCategory.getVocabularyId());
                            return assetVocabulary.getTitle(dtoConverterContext.getLocale());
                        });
                    }
                };
                this.taxonomyCategoryUsageCount = (int)TaxonomyCategoryDTOConverter.this._assetEntryLocalService.searchCount(assetCategory.getCompanyId(), new long[]{assetCategory.getGroupId()}, assetCategory.getUserId(), null, 0L, null, String.valueOf(assetCategory.getCategoryId()), null, false, false, new int[]{0, 1, 7}, false);
                this.setParentTaxonomyCategory(() -> {
                    if (assetCategory.getParentCategory() == null) {
                        return null;
                    }
                    return TaxonomyCategoryDTOConverter.this._toParentTaxonomyCategory(assetCategory.getParentCategory(), dtoConverterContext);
                });
            }
        };
    }
}

