/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseTaxonomyCategoryResourceImpl
implements EntityModelResource,
TaxonomyCategoryResource,
VulcanBatchEngineTaskItemDelegate<TaxonomyCategory> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Path(value="/taxonomy-categories/ranked")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Page<TaxonomyCategory> getTaxonomyCategoryRankedPage(@Parameter(hidden=true) @QueryParam(value="siteId") Long siteId, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Operation(description="Retrieves a taxonomy category's child taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentTaxonomyCategoryId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/taxonomy-categories/{parentTaxonomyCategoryId}/taxonomy-categories")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Page<TaxonomyCategory> getTaxonomyCategoryTaxonomyCategoriesPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentTaxonomyCategoryId") String parentTaxonomyCategoryId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Inserts a new child taxonomy category.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentTaxonomyCategoryId")})
    @Path(value="/taxonomy-categories/{parentTaxonomyCategoryId}/taxonomy-categories")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public TaxonomyCategory postTaxonomyCategoryTaxonomyCategory(@NotNull @Parameter(hidden=true) @PathParam(value="parentTaxonomyCategoryId") String parentTaxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        return new TaxonomyCategory();
    }

    @DELETE
    @Operation(description="Deletes the taxonomy category and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public void deleteTaxonomyCategory(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/taxonomy-categories/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Response deleteTaxonomyCategoryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(TaxonomyCategory.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves a taxonomy category.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public TaxonomyCategory getTaxonomyCategory(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId) throws Exception {
        return new TaxonomyCategory();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body. Other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @PATCH
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public TaxonomyCategory patchTaxonomyCategory(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        TaxonomyCategory existingTaxonomyCategory = this.getTaxonomyCategory(taxonomyCategoryId);
        if (taxonomyCategory.getActions() != null) {
            existingTaxonomyCategory.setActions(taxonomyCategory.getActions());
        }
        if (taxonomyCategory.getAvailableLanguages() != null) {
            existingTaxonomyCategory.setAvailableLanguages(taxonomyCategory.getAvailableLanguages());
        }
        if (taxonomyCategory.getDateCreated() != null) {
            existingTaxonomyCategory.setDateCreated(taxonomyCategory.getDateCreated());
        }
        if (taxonomyCategory.getDateModified() != null) {
            existingTaxonomyCategory.setDateModified(taxonomyCategory.getDateModified());
        }
        if (taxonomyCategory.getDescription() != null) {
            existingTaxonomyCategory.setDescription(taxonomyCategory.getDescription());
        }
        if (taxonomyCategory.getDescription_i18n() != null) {
            existingTaxonomyCategory.setDescription_i18n(taxonomyCategory.getDescription_i18n());
        }
        if (taxonomyCategory.getExternalReferenceCode() != null) {
            existingTaxonomyCategory.setExternalReferenceCode(taxonomyCategory.getExternalReferenceCode());
        }
        if (taxonomyCategory.getName() != null) {
            existingTaxonomyCategory.setName(taxonomyCategory.getName());
        }
        if (taxonomyCategory.getName_i18n() != null) {
            existingTaxonomyCategory.setName_i18n(taxonomyCategory.getName_i18n());
        }
        if (taxonomyCategory.getNumberOfTaxonomyCategories() != null) {
            existingTaxonomyCategory.setNumberOfTaxonomyCategories(taxonomyCategory.getNumberOfTaxonomyCategories());
        }
        if (taxonomyCategory.getTaxonomyCategoryUsageCount() != null) {
            existingTaxonomyCategory.setTaxonomyCategoryUsageCount(taxonomyCategory.getTaxonomyCategoryUsageCount());
        }
        if (taxonomyCategory.getViewableBy() != null) {
            existingTaxonomyCategory.setViewableBy(taxonomyCategory.getViewableBy());
        }
        this.preparePatch(taxonomyCategory, existingTaxonomyCategory);
        return this.putTaxonomyCategory(taxonomyCategoryId, existingTaxonomyCategory);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the taxonomy category with the information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public TaxonomyCategory putTaxonomyCategory(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, TaxonomyCategory taxonomyCategory) throws Exception {
        return new TaxonomyCategory();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/taxonomy-categories/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Response putTaxonomyCategoryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(TaxonomyCategory.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Page<Permission> getTaxonomyCategoryPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(taxonomyCategoryId);
        Long resourceId = this.getPermissionCheckerResourceId(taxonomyCategoryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(taxonomyCategoryId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getTaxonomyCategoryPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putTaxonomyCategoryPermission", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyCategoryId")})
    @Path(value="/taxonomy-categories/{taxonomyCategoryId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Page<Permission> putTaxonomyCategoryPermission(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyCategoryId") String taxonomyCategoryId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(taxonomyCategoryId);
        Long resourceId = this.getPermissionCheckerResourceId(taxonomyCategoryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(taxonomyCategoryId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(taxonomyCategoryId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getTaxonomyCategoryPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putTaxonomyCategoryPermission", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @GET
    @Operation(description="Retrieves a vocabulary's taxonomy categories. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Page<TaxonomyCategory> getTaxonomyVocabularyTaxonomyCategoriesPage(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Inserts a new taxonomy category in a taxonomy vocabulary.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public TaxonomyCategory postTaxonomyVocabularyTaxonomyCategory(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyCategory taxonomyCategory) throws Exception {
        return new TaxonomyCategory();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/taxonomy-categories/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="TaxonomyCategory")})
    public Response postTaxonomyVocabularyTaxonomyCategoryBatch(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(TaxonomyCategory.class.getName(), callbackURL, null, object)).build();
    }

    public void create(Collection<TaxonomyCategory> taxonomyCategories, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyCategory taxonomyCategory : taxonomyCategories) {
            this.postTaxonomyVocabularyTaxonomyCategory(Long.parseLong((String)((Object)parameters.get("taxonomyVocabularyId"))), taxonomyCategory);
        }
    }

    public void delete(Collection<TaxonomyCategory> taxonomyCategories, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyCategory taxonomyCategory : taxonomyCategories) {
            this.deleteTaxonomyCategory(taxonomyCategory.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<TaxonomyCategory> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return null;
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<TaxonomyCategory> taxonomyCategories, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyCategory taxonomyCategory : taxonomyCategories) {
            this.putTaxonomyCategory(taxonomyCategory.getId() != null ? taxonomyCategory.getId() : (String)((Object)parameters.get("taxonomyCategoryId")), taxonomyCategory);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(TaxonomyCategory taxonomyCategory, TaxonomyCategory existingTaxonomyCategory) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

