/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.taxonomy.internal.resource.v1_0;

import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseTaxonomyVocabularyResourceImpl
implements EntityModelResource,
TaxonomyVocabularyResource,
VulcanBatchEngineTaskItemDelegate<TaxonomyVocabulary> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/asset-libraries/{assetLibraryId}/taxonomy-vocabularies")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<TaxonomyVocabulary> getAssetLibraryTaxonomyVocabulariesPage(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Path(value="/asset-libraries/{assetLibraryId}/taxonomy-vocabularies")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary postAssetLibraryTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/asset-libraries/{assetLibraryId}/taxonomy-vocabularies/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Response postAssetLibraryTaxonomyVocabularyBatch(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(TaxonomyVocabulary.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/asset-libraries/{assetLibraryId}/taxonomy-vocabularies/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<Permission> getAssetLibraryTaxonomyVocabularyPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryTaxonomyVocabularyPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryTaxonomyVocabularyPermission", portletName, assetLibraryId)).build(), assetLibraryId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Path(value="/asset-libraries/{assetLibraryId}/taxonomy-vocabularies/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<Permission> putAssetLibraryTaxonomyVocabularyPermission(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), assetLibraryId.longValue(), portletName, String.valueOf(assetLibraryId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)assetLibraryId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryTaxonomyVocabularyPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryTaxonomyVocabularyPermission", portletName, assetLibraryId)).build(), assetLibraryId, portletName, null);
    }

    @GET
    @Operation(description="Retrieves a Site's taxonomy vocabularies. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<TaxonomyVocabulary> getSiteTaxonomyVocabulariesPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Inserts a new taxonomy vocabulary in a Site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary postSiteTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Response postSiteTaxonomyVocabularyBatch(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(TaxonomyVocabulary.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<Permission> getSiteTaxonomyVocabularyPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteTaxonomyVocabularyPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteTaxonomyVocabularyPermission", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/taxonomy-vocabularies/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<Permission> putSiteTaxonomyVocabularyPermission(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteTaxonomyVocabularyPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteTaxonomyVocabularyPermission", portletName, siteId)).build(), siteId, portletName, null);
    }

    @DELETE
    @Operation(description="Deletes the taxonomy vocabulary and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public void deleteTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/taxonomy-vocabularies/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Response deleteTaxonomyVocabularyBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(TaxonomyVocabulary.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves a taxonomy vocabulary.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary getTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body. Any other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @PATCH
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary patchTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        TaxonomyVocabulary existingTaxonomyVocabulary = this.getTaxonomyVocabulary(taxonomyVocabularyId);
        if (taxonomyVocabulary.getActions() != null) {
            existingTaxonomyVocabulary.setActions(taxonomyVocabulary.getActions());
        }
        if (taxonomyVocabulary.getAssetLibraryKey() != null) {
            existingTaxonomyVocabulary.setAssetLibraryKey(taxonomyVocabulary.getAssetLibraryKey());
        }
        if (taxonomyVocabulary.getAvailableLanguages() != null) {
            existingTaxonomyVocabulary.setAvailableLanguages(taxonomyVocabulary.getAvailableLanguages());
        }
        if (taxonomyVocabulary.getDateCreated() != null) {
            existingTaxonomyVocabulary.setDateCreated(taxonomyVocabulary.getDateCreated());
        }
        if (taxonomyVocabulary.getDateModified() != null) {
            existingTaxonomyVocabulary.setDateModified(taxonomyVocabulary.getDateModified());
        }
        if (taxonomyVocabulary.getDescription() != null) {
            existingTaxonomyVocabulary.setDescription(taxonomyVocabulary.getDescription());
        }
        if (taxonomyVocabulary.getDescription_i18n() != null) {
            existingTaxonomyVocabulary.setDescription_i18n(taxonomyVocabulary.getDescription_i18n());
        }
        if (taxonomyVocabulary.getName() != null) {
            existingTaxonomyVocabulary.setName(taxonomyVocabulary.getName());
        }
        if (taxonomyVocabulary.getName_i18n() != null) {
            existingTaxonomyVocabulary.setName_i18n(taxonomyVocabulary.getName_i18n());
        }
        if (taxonomyVocabulary.getNumberOfTaxonomyCategories() != null) {
            existingTaxonomyVocabulary.setNumberOfTaxonomyCategories(taxonomyVocabulary.getNumberOfTaxonomyCategories());
        }
        if (taxonomyVocabulary.getSiteId() != null) {
            existingTaxonomyVocabulary.setSiteId(taxonomyVocabulary.getSiteId());
        }
        if (taxonomyVocabulary.getViewableBy() != null) {
            existingTaxonomyVocabulary.setViewableBy(taxonomyVocabulary.getViewableBy());
        }
        this.preparePatch(taxonomyVocabulary, existingTaxonomyVocabulary);
        return this.putTaxonomyVocabulary(taxonomyVocabularyId, existingTaxonomyVocabulary);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the taxonomy vocabulary with the information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public TaxonomyVocabulary putTaxonomyVocabulary(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, TaxonomyVocabulary taxonomyVocabulary) throws Exception {
        return new TaxonomyVocabulary();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/taxonomy-vocabularies/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Response putTaxonomyVocabularyBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(TaxonomyVocabulary.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<Permission> getTaxonomyVocabularyPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(taxonomyVocabularyId);
        Long resourceId = this.getPermissionCheckerResourceId(taxonomyVocabularyId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(taxonomyVocabularyId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getTaxonomyVocabularyPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putTaxonomyVocabularyPermission", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="taxonomyVocabularyId")})
    @Path(value="/taxonomy-vocabularies/{taxonomyVocabularyId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="TaxonomyVocabulary")})
    public Page<Permission> putTaxonomyVocabularyPermission(@NotNull @Parameter(hidden=true) @PathParam(value="taxonomyVocabularyId") Long taxonomyVocabularyId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(taxonomyVocabularyId);
        Long resourceId = this.getPermissionCheckerResourceId(taxonomyVocabularyId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(taxonomyVocabularyId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(taxonomyVocabularyId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getTaxonomyVocabularyPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putTaxonomyVocabularyPermission", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    public void create(Collection<TaxonomyVocabulary> taxonomyVocabularies, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyVocabulary taxonomyVocabulary : taxonomyVocabularies) {
            this.postSiteTaxonomyVocabulary(Long.parseLong((String)((Object)parameters.get("siteId"))), taxonomyVocabulary);
        }
    }

    public void delete(Collection<TaxonomyVocabulary> taxonomyVocabularies, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyVocabulary taxonomyVocabulary : taxonomyVocabularies) {
            this.deleteTaxonomyVocabulary(taxonomyVocabulary.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<TaxonomyVocabulary> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return null;
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<TaxonomyVocabulary> taxonomyVocabularies, Map<String, Serializable> parameters) throws Exception {
        for (TaxonomyVocabulary taxonomyVocabulary : taxonomyVocabularies) {
            this.putTaxonomyVocabulary(taxonomyVocabulary.getId() != null ? taxonomyVocabulary.getId() : Long.parseLong((String)((Object)parameters.get("taxonomyVocabularyId"))), taxonomyVocabulary);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(TaxonomyVocabulary taxonomyVocabulary, TaxonomyVocabulary existingTaxonomyVocabulary) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

