/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.workflow.client.dto.v1_0;

import com.liferay.headless.admin.workflow.client.function.UnsafeSupplier;
import com.liferay.headless.admin.workflow.client.serdes.v1_0.NodeSerDes;
import java.io.Serializable;
import java.util.Objects;

public class Node
implements Cloneable,
Serializable {
    protected String label;
    protected String name;
    protected Type type;

    public static Node toDTO(String json) {
        return NodeSerDes.toDTO(json);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabel(UnsafeSupplier<String, Exception> labelUnsafeSupplier) {
        try {
            this.label = labelUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = nameUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        try {
            this.type = typeUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Node clone() throws CloneNotSupportedException {
        return (Node)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Node)) {
            return false;
        }
        Node node = (Node)object;
        return Objects.equals(this.toString(), node.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return NodeSerDes.toJSON(this);
    }

    public static enum Type {
        CONDITION("CONDITION"),
        FORK("FORK"),
        INITIAL_STATE("INITIAL_STATE"),
        JOIN("JOIN"),
        JOIN_XOR("JOIN_XOR"),
        STATE("STATE"),
        TASK("TASK"),
        TERMINAL_STATE("TERMINAL_STATE");

        private final String _value;

        public static Type create(String value) {
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value) && !Objects.equals(type.name(), value)) continue;
                return type;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

