/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.batch.engine.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="ExportTask")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="ExportTask")
public class ExportTask
implements Serializable {
    @GraphQLField(description="The item class name for which data will be exported in batch.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The item class name for which data will be exported in batch.") String className;
    @GraphQLField(description="The file content type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The file content type.") String contentType;
    @GraphQLField(description="The end time of import task operation.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The end time of import task operation.") Date endTime;
    @GraphQLField(description="The error message in case of import task's failed execution.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The error message in case of import task's failed execution.") String errorMessage;
    @GraphQLField(description="The status of import task's execution.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The status of import task's execution.") ExecuteStatus executeStatus;
    @GraphQLField(description="The task's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The task's ID.") Long id;
    @GraphQLField(description="The start time of import task operation.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The start time of import task operation.") Date startTime;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.batch.engine.dto.v1_0.ExportTask", name="x-class-name")
    public String xClassName;

    public static ExportTask toDTO(String json) {
        return (ExportTask)ObjectMapperUtil.readValue(ExportTask.class, (String)json);
    }

    @Schema(description="The item class name for which data will be exported in batch.")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @JsonIgnore
    public void setClassName(UnsafeSupplier<String, Exception> classNameUnsafeSupplier) {
        try {
            this.className = (String)classNameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The file content type.")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonIgnore
    public void setContentType(UnsafeSupplier<String, Exception> contentTypeUnsafeSupplier) {
        try {
            this.contentType = (String)contentTypeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The end time of import task operation.")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @JsonIgnore
    public void setEndTime(UnsafeSupplier<Date, Exception> endTimeUnsafeSupplier) {
        try {
            this.endTime = (Date)endTimeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The error message in case of import task's failed execution.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @JsonIgnore
    public void setErrorMessage(UnsafeSupplier<String, Exception> errorMessageUnsafeSupplier) {
        try {
            this.errorMessage = (String)errorMessageUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The status of import task's execution.")
    @Valid
    public ExecuteStatus getExecuteStatus() {
        return this.executeStatus;
    }

    @JsonIgnore
    public String getExecuteStatusAsString() {
        if (this.executeStatus == null) {
            return null;
        }
        return this.executeStatus.toString();
    }

    public void setExecuteStatus(ExecuteStatus executeStatus) {
        this.executeStatus = executeStatus;
    }

    @JsonIgnore
    public void setExecuteStatus(UnsafeSupplier<ExecuteStatus, Exception> executeStatusUnsafeSupplier) {
        try {
            this.executeStatus = (ExecuteStatus)((Object)executeStatusUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema(description="The task's ID.")
    public @DecimalMin(value="0") Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The start time of import task operation.")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonIgnore
    public void setStartTime(UnsafeSupplier<Date, Exception> startTimeUnsafeSupplier) {
        try {
            this.startTime = (Date)startTimeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExportTask)) {
            return false;
        }
        ExportTask exportTask = (ExportTask)object;
        return Objects.equals(this.toString(), exportTask.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.className != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"className\": ");
            sb.append("\"");
            sb.append(ExportTask._escape(this.className));
            sb.append("\"");
        }
        if (this.contentType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentType\": ");
            sb.append("\"");
            sb.append(ExportTask._escape(this.contentType));
            sb.append("\"");
        }
        if (this.endTime != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"endTime\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.endTime));
            sb.append("\"");
        }
        if (this.errorMessage != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"errorMessage\": ");
            sb.append("\"");
            sb.append(ExportTask._escape(this.errorMessage));
            sb.append("\"");
        }
        if (this.executeStatus != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"executeStatus\": ");
            sb.append("\"");
            sb.append((Object)this.executeStatus);
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.startTime != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"startTime\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.startTime));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (ExportTask._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ExportTask._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ExecuteStatus")
    public static enum ExecuteStatus {
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        INITIAL("INITIAL"),
        STARTED("STARTED");

        private final String _value;

        @JsonCreator
        public static ExecuteStatus create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ExecuteStatus executeStatus : ExecuteStatus.values()) {
                if (!Objects.equals(executeStatus.getValue(), value)) continue;
                return executeStatus;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ExecuteStatus(String value) {
            this._value = value;
        }
    }
}

