/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.batch.engine.client.resource.v1_0;

import com.liferay.headless.batch.engine.client.dto.v1_0.ImportTask;
import com.liferay.headless.batch.engine.client.http.HttpInvoker;
import com.liferay.headless.batch.engine.client.problem.Problem;
import com.liferay.headless.batch.engine.client.serdes.v1_0.ImportTaskSerDes;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface ImportTaskResource {
    public static Builder builder() {
        return new Builder();
    }

    public ImportTask getImportTaskByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse getImportTaskByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public void getImportTaskByExternalReferenceCodeContent(String var1) throws Exception;

    public HttpInvoker.HttpResponse getImportTaskByExternalReferenceCodeContentHttpResponse(String var1) throws Exception;

    public void getImportTaskByExternalReferenceCodeFailedItemReport(String var1) throws Exception;

    public HttpInvoker.HttpResponse getImportTaskByExternalReferenceCodeFailedItemReportHttpResponse(String var1) throws Exception;

    public ImportTask deleteImportTask(String var1, String var2, String var3, String var4, String var5, Object var6) throws Exception;

    public HttpInvoker.HttpResponse deleteImportTaskHttpResponse(String var1, String var2, String var3, String var4, String var5, Object var6) throws Exception;

    public ImportTask deleteFormDataImportTask(String var1, String var2, String var3, String var4, String var5, ImportTask var6, Map<String, File> var7) throws Exception;

    public HttpInvoker.HttpResponse deleteFormDataImportTaskHttpResponse(String var1, String var2, String var3, String var4, String var5, ImportTask var6, Map<String, File> var7) throws Exception;

    public ImportTask postImportTask(String var1, String var2, String var3, String var4, String var5, String var6, String var7, Object var8) throws Exception;

    public HttpInvoker.HttpResponse postImportTaskHttpResponse(String var1, String var2, String var3, String var4, String var5, String var6, String var7, Object var8) throws Exception;

    public ImportTask postFormDataImportTask(String var1, String var2, String var3, String var4, String var5, String var6, String var7, ImportTask var8, Map<String, File> var9) throws Exception;

    public HttpInvoker.HttpResponse postFormDataImportTaskHttpResponse(String var1, String var2, String var3, String var4, String var5, String var6, String var7, ImportTask var8, Map<String, File> var9) throws Exception;

    public ImportTask putImportTask(String var1, String var2, String var3, String var4, String var5, String var6, Object var7) throws Exception;

    public HttpInvoker.HttpResponse putImportTaskHttpResponse(String var1, String var2, String var3, String var4, String var5, String var6, Object var7) throws Exception;

    public ImportTask putFormDataImportTask(String var1, String var2, String var3, String var4, String var5, String var6, ImportTask var7, Map<String, File> var8) throws Exception;

    public HttpInvoker.HttpResponse putFormDataImportTaskHttpResponse(String var1, String var2, String var3, String var4, String var5, String var6, ImportTask var7, Map<String, File> var8) throws Exception;

    public ImportTask getImportTask(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getImportTaskHttpResponse(Long var1) throws Exception;

    public void getImportTaskContent(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getImportTaskContentHttpResponse(Long var1) throws Exception;

    public void getImportTaskFailedItemReport(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getImportTaskFailedItemReportHttpResponse(Long var1) throws Exception;

    public static class ImportTaskResourceImpl
    implements ImportTaskResource {
        private static final Logger _logger = Logger.getLogger(ImportTaskResource.class.getName());
        private Builder _builder;

        @Override
        public ImportTask getImportTaskByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getImportTaskByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getImportTaskByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void getImportTaskByExternalReferenceCodeContent(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getImportTaskByExternalReferenceCodeContentHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse getImportTaskByExternalReferenceCodeContentHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/by-external-reference-code/{externalReferenceCode}/content");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void getImportTaskByExternalReferenceCodeFailedItemReport(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getImportTaskByExternalReferenceCodeFailedItemReportHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse getImportTaskByExternalReferenceCodeFailedItemReportHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/by-external-reference-code/{externalReferenceCode}/failed-items/report");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ImportTask deleteImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteImportTaskHttpResponse(className, callbackURL, externalReferenceCode, importStrategy, taskItemDelegateName, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse deleteImportTaskHttpResponse(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (externalReferenceCode != null) {
                httpInvoker.parameter("externalReferenceCode", String.valueOf(externalReferenceCode));
            }
            if (importStrategy != null) {
                httpInvoker.parameter("importStrategy", String.valueOf(importStrategy));
            }
            if (taskItemDelegateName != null) {
                httpInvoker.parameter("taskItemDelegateName", String.valueOf(taskItemDelegateName));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{className}");
            httpInvoker.path("className", className);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ImportTask deleteFormDataImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, ImportTask importTask, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteFormDataImportTaskHttpResponse(className, callbackURL, externalReferenceCode, importStrategy, taskItemDelegateName, importTask, multipartFiles);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse deleteFormDataImportTaskHttpResponse(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, ImportTask importTask, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.multipart();
            httpInvoker.part("importTask", ImportTaskSerDes.toJSON(importTask));
            for (Map.Entry<String, File> entry : multipartFiles.entrySet()) {
                httpInvoker.part(entry.getKey(), entry.getValue());
            }
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, File> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), (String)((Object)entry.getValue()));
            }
            for (Map.Entry<String, File> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), (String)((Object)entry.getValue()));
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (externalReferenceCode != null) {
                httpInvoker.parameter("externalReferenceCode", String.valueOf(externalReferenceCode));
            }
            if (importStrategy != null) {
                httpInvoker.parameter("importStrategy", String.valueOf(importStrategy));
            }
            if (taskItemDelegateName != null) {
                httpInvoker.parameter("taskItemDelegateName", String.valueOf(taskItemDelegateName));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{className}");
            httpInvoker.path("className", className);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ImportTask postImportTask(String className, String callbackURL, String createStrategy, String externalReferenceCode, String fieldNameMapping, String importStrategy, String taskItemDelegateName, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postImportTaskHttpResponse(className, callbackURL, createStrategy, externalReferenceCode, fieldNameMapping, importStrategy, taskItemDelegateName, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postImportTaskHttpResponse(String className, String callbackURL, String createStrategy, String externalReferenceCode, String fieldNameMapping, String importStrategy, String taskItemDelegateName, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (createStrategy != null) {
                httpInvoker.parameter("createStrategy", String.valueOf(createStrategy));
            }
            if (externalReferenceCode != null) {
                httpInvoker.parameter("externalReferenceCode", String.valueOf(externalReferenceCode));
            }
            if (fieldNameMapping != null) {
                httpInvoker.parameter("fieldNameMapping", String.valueOf(fieldNameMapping));
            }
            if (importStrategy != null) {
                httpInvoker.parameter("importStrategy", String.valueOf(importStrategy));
            }
            if (taskItemDelegateName != null) {
                httpInvoker.parameter("taskItemDelegateName", String.valueOf(taskItemDelegateName));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{className}");
            httpInvoker.path("className", className);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ImportTask postFormDataImportTask(String className, String callbackURL, String createStrategy, String externalReferenceCode, String fieldNameMapping, String importStrategy, String taskItemDelegateName, ImportTask importTask, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postFormDataImportTaskHttpResponse(className, callbackURL, createStrategy, externalReferenceCode, fieldNameMapping, importStrategy, taskItemDelegateName, importTask, multipartFiles);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postFormDataImportTaskHttpResponse(String className, String callbackURL, String createStrategy, String externalReferenceCode, String fieldNameMapping, String importStrategy, String taskItemDelegateName, ImportTask importTask, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.multipart();
            httpInvoker.part("importTask", ImportTaskSerDes.toJSON(importTask));
            for (Map.Entry<String, File> entry : multipartFiles.entrySet()) {
                httpInvoker.part(entry.getKey(), entry.getValue());
            }
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, File> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), (String)((Object)entry.getValue()));
            }
            for (Map.Entry<String, File> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), (String)((Object)entry.getValue()));
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (createStrategy != null) {
                httpInvoker.parameter("createStrategy", String.valueOf(createStrategy));
            }
            if (externalReferenceCode != null) {
                httpInvoker.parameter("externalReferenceCode", String.valueOf(externalReferenceCode));
            }
            if (fieldNameMapping != null) {
                httpInvoker.parameter("fieldNameMapping", String.valueOf(fieldNameMapping));
            }
            if (importStrategy != null) {
                httpInvoker.parameter("importStrategy", String.valueOf(importStrategy));
            }
            if (taskItemDelegateName != null) {
                httpInvoker.parameter("taskItemDelegateName", String.valueOf(taskItemDelegateName));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{className}");
            httpInvoker.path("className", className);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ImportTask putImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, String updateStrategy, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putImportTaskHttpResponse(className, callbackURL, externalReferenceCode, importStrategy, taskItemDelegateName, updateStrategy, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putImportTaskHttpResponse(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, String updateStrategy, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (externalReferenceCode != null) {
                httpInvoker.parameter("externalReferenceCode", String.valueOf(externalReferenceCode));
            }
            if (importStrategy != null) {
                httpInvoker.parameter("importStrategy", String.valueOf(importStrategy));
            }
            if (taskItemDelegateName != null) {
                httpInvoker.parameter("taskItemDelegateName", String.valueOf(taskItemDelegateName));
            }
            if (updateStrategy != null) {
                httpInvoker.parameter("updateStrategy", String.valueOf(updateStrategy));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{className}");
            httpInvoker.path("className", className);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ImportTask putFormDataImportTask(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, String updateStrategy, ImportTask importTask, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putFormDataImportTaskHttpResponse(className, callbackURL, externalReferenceCode, importStrategy, taskItemDelegateName, updateStrategy, importTask, multipartFiles);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putFormDataImportTaskHttpResponse(String className, String callbackURL, String externalReferenceCode, String importStrategy, String taskItemDelegateName, String updateStrategy, ImportTask importTask, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.multipart();
            httpInvoker.part("importTask", ImportTaskSerDes.toJSON(importTask));
            for (Map.Entry<String, File> entry : multipartFiles.entrySet()) {
                httpInvoker.part(entry.getKey(), entry.getValue());
            }
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, File> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), (String)((Object)entry.getValue()));
            }
            for (Map.Entry<String, File> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), (String)((Object)entry.getValue()));
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (externalReferenceCode != null) {
                httpInvoker.parameter("externalReferenceCode", String.valueOf(externalReferenceCode));
            }
            if (importStrategy != null) {
                httpInvoker.parameter("importStrategy", String.valueOf(importStrategy));
            }
            if (taskItemDelegateName != null) {
                httpInvoker.parameter("taskItemDelegateName", String.valueOf(taskItemDelegateName));
            }
            if (updateStrategy != null) {
                httpInvoker.parameter("updateStrategy", String.valueOf(updateStrategy));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{className}");
            httpInvoker.path("className", className);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ImportTask getImportTask(Long importTaskId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getImportTaskHttpResponse(importTaskId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ImportTaskSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getImportTaskHttpResponse(Long importTaskId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{importTaskId}");
            httpInvoker.path("importTaskId", importTaskId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void getImportTaskContent(Long importTaskId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getImportTaskContentHttpResponse(importTaskId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse getImportTaskContentHttpResponse(Long importTaskId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{importTaskId}/content");
            httpInvoker.path("importTaskId", importTaskId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void getImportTaskFailedItemReport(Long importTaskId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getImportTaskFailedItemReportHttpResponse(importTaskId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse getImportTaskFailedItemReportHttpResponse(Long importTaskId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-batch-engine/v1.0/import-task/{importTaskId}/failed-items/report");
            httpInvoker.path("importTaskId", importTaskId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private ImportTaskResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public ImportTaskResource build() {
            return new ImportTaskResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

