/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.batch.engine.internal.resource.v1_0;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.ItemClassRegistry;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.headless.batch.engine.dto.v1_0.ExportTask;
import com.liferay.headless.batch.engine.internal.resource.v1_0.BaseExportTaskResourceImpl;
import com.liferay.headless.batch.engine.internal.resource.v1_0.util.ParametersUtil;
import com.liferay.headless.batch.engine.resource.v1_0.ExportTaskResource;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/export-task.properties"}, property={"batch.engine=true"}, scope=ServiceScope.PROTOTYPE, service={ExportTaskResource.class})
public class ExportTaskResourceImpl
extends BaseExportTaskResourceImpl {
    private static final Set<String> _ignoredParameters = new HashSet<String>(Arrays.asList("callbackURL", "fieldNames"));
    @Reference
    private BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private ItemClassRegistry _itemClassRegistry;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    @Override
    public ExportTask getExportTask(Long exportTaskId) throws Exception {
        return this._toExportTask(this._batchEngineExportTaskLocalService.getBatchEngineExportTask(exportTaskId.longValue()));
    }

    @Override
    public Response getExportTaskContent(Long exportTaskId) throws Exception {
        BatchEngineExportTask batchEngineExportTask = this._batchEngineExportTaskLocalService.getBatchEngineExportTask(exportTaskId.longValue());
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineExportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.COMPLETED) {
            StreamingOutput streamingOutput = outputStream -> StreamUtil.transfer((InputStream)this._batchEngineExportTaskLocalService.openContentInputStream(exportTaskId.longValue()), (OutputStream)outputStream);
            return Response.ok((Object)streamingOutput).header("content-disposition", (Object)"attachment; filename=export.zip").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public ExportTask postExportTask(String className, String contentType, String callbackURL, String fieldNames, String taskItemDelegateName) throws Exception {
        Class clazz = this._itemClassRegistry.getItemClass(className);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown class name: " + className);
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(ExportTaskResourceImpl.class.getName());
        BatchEngineExportTask batchEngineExportTask = this._batchEngineExportTaskLocalService.addBatchEngineExportTask(this.contextCompany.getCompanyId(), this.contextUser.getUserId(), callbackURL, className, StringUtil.upperCase((String)contentType), BatchEngineTaskExecuteStatus.INITIAL.name(), this._toList(fieldNames), ParametersUtil.toParameters(this.contextUriInfo, _ignoredParameters), taskItemDelegateName);
        executorService.submit(() -> this._batchEngineExportTaskExecutor.execute(batchEngineExportTask));
        return this._toExportTask(batchEngineExportTask);
    }

    private ExportTask _toExportTask(final BatchEngineExportTask batchEngineExportTask) {
        return new ExportTask(){
            {
                this.className = batchEngineExportTask.getClassName();
                this.contentType = batchEngineExportTask.getContentType();
                this.endTime = batchEngineExportTask.getEndTime();
                this.errorMessage = batchEngineExportTask.getErrorMessage();
                this.executeStatus = ExportTask.ExecuteStatus.valueOf((String)batchEngineExportTask.getExecuteStatus());
                this.id = batchEngineExportTask.getBatchEngineExportTaskId();
                this.startTime = batchEngineExportTask.getStartTime();
            }
        };
    }

    private List<String> _toList(String fieldNamesString) {
        if (Validator.isNull((String)fieldNamesString)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtil.split((String)fieldNamesString, (char)','));
    }
}

