/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.common.spi.service.context;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.Map;

public class ServiceContextUtil {
    public static ServiceContext createServiceContext(long groupId, String viewableBy) {
        return ServiceContextUtil.createServiceContext(new Long[0], new String[0], groupId, viewableBy);
    }

    public static ServiceContext createServiceContext(Long[] assetCategoryIds, String[] assetTagNames, Long groupId, String viewableBy) {
        return ServiceContextUtil.createServiceContext(assetCategoryIds, assetTagNames, null, groupId, viewableBy);
    }

    public static ServiceContext createServiceContext(final Long[] assetCategoryIds, final String[] assetTagNames, final Map<String, Serializable> expandoBridgeAttributes, final Long groupId, final String viewableBy) {
        return new ServiceContext(){
            {
                if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"anyone")) {
                    this.setAddGuestPermissions(true);
                    this.setAddGroupPermissions(true);
                } else if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"members")) {
                    this.setAddGuestPermissions(false);
                    this.setAddGroupPermissions(true);
                } else {
                    this.setAddGuestPermissions(false);
                    this.setAddGroupPermissions(false);
                }
                if (assetCategoryIds != null) {
                    this.setAssetCategoryIds(ArrayUtil.toArray((Long[])assetCategoryIds));
                }
                if (assetTagNames != null) {
                    this.setAssetTagNames(assetTagNames);
                }
                if (expandoBridgeAttributes != null) {
                    this.setExpandoBridgeAttributes(expandoBridgeAttributes);
                }
                if (groupId != null) {
                    this.setScopeGroupId(groupId);
                }
            }
        };
    }

    public static ServiceContext createServiceContext(Map<String, Serializable> expandoBridgeAttributes, long groupId, String viewableBy) {
        return ServiceContextUtil.createServiceContext(new Long[0], new String[0], expandoBridgeAttributes, groupId, viewableBy);
    }
}

