/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.common.spi.service.context;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextRequestUtil {
    public static ServiceContext createServiceContext(long groupId, HttpServletRequest httpServletRequest, String viewableBy) {
        return ServiceContextRequestUtil.createServiceContext(new Long[0], new String[0], null, groupId, httpServletRequest, viewableBy);
    }

    public static ServiceContext createServiceContext(Long[] assetCategoryIds, String[] assetTagNames, Map<String, Serializable> expandoBridgeAttributes, Long groupId, HttpServletRequest httpServletRequest, String viewableBy) {
        ServiceContext serviceContext = new ServiceContext();
        if (httpServletRequest != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String header = (String)enumeration.nextElement();
                String value = httpServletRequest.getHeader(header);
                headers.put(header, value);
            }
            serviceContext.setHeaders(headers);
        }
        if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"anyone")) {
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
        } else if (StringUtil.equalsIgnoreCase((String)viewableBy, (String)"members")) {
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(false);
        } else {
            serviceContext.setAddGroupPermissions(false);
            serviceContext.setAddGuestPermissions(false);
        }
        if (assetCategoryIds != null) {
            serviceContext.setAssetCategoryIds(ArrayUtil.toArray((Long[])assetCategoryIds));
        }
        if (assetTagNames != null) {
            serviceContext.setAssetTagNames(assetTagNames);
        }
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        if (groupId != null) {
            serviceContext.setScopeGroupId(groupId.longValue());
        }
        return serviceContext;
    }

    public static ServiceContext createServiceContext(Map<String, Serializable> expandoBridgeAttributes, long groupId, HttpServletRequest httpServletRequest, String viewableBy) {
        return ServiceContextRequestUtil.createServiceContext(new Long[0], new String[0], expandoBridgeAttributes, groupId, httpServletRequest, viewableBy);
    }
}

