/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a comment. See [Comment](https://www.schema.org/Comment) for more details.", value="Comment")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Comment")
public class Comment
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @GraphQLField(description="The comment's author.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The comment's author.") Creator creator;
    @GraphQLField(description="The comment's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The comment's creation date.") Date dateCreated;
    @GraphQLField(description="The comment's latest modification date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The comment's latest modification date.") Date dateModified;
    @GraphQLField(description="The comment's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The comment's ID.") Long id;
    @GraphQLField(description="The number of child comments on this comment.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of child comments on this comment.") Integer numberOfComments;
    @GraphQLField(description="the ID of the comment's parent, if it exists.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="the ID of the comment's parent, if it exists.") Long parentCommentId;
    @GraphQLField(description="The comment's text content.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The comment's text content.") String text;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.Comment", name="x-class-name")
    public String xClassName;

    public static Comment toDTO(String json) {
        return (Comment)ObjectMapperUtil.readValue(Comment.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The comment's author.")
    @Valid
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The comment's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The comment's latest modification date.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The comment's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of child comments on this comment.")
    public Integer getNumberOfComments() {
        return this.numberOfComments;
    }

    public void setNumberOfComments(Integer numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    @JsonIgnore
    public void setNumberOfComments(UnsafeSupplier<Integer, Exception> numberOfCommentsUnsafeSupplier) {
        try {
            this.numberOfComments = (Integer)numberOfCommentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="the ID of the comment's parent, if it exists.")
    public Long getParentCommentId() {
        return this.parentCommentId;
    }

    public void setParentCommentId(Long parentCommentId) {
        this.parentCommentId = parentCommentId;
    }

    @JsonIgnore
    public void setParentCommentId(UnsafeSupplier<Long, Exception> parentCommentIdUnsafeSupplier) {
        try {
            this.parentCommentId = (Long)parentCommentIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The comment's text content.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JsonIgnore
    public void setText(UnsafeSupplier<String, Exception> textUnsafeSupplier) {
        try {
            this.text = (String)textUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Comment)) {
            return false;
        }
        Comment comment = (Comment)object;
        return Objects.equals(this.toString(), comment.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(Comment._toJSON(this.actions));
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.numberOfComments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfComments\": ");
            sb.append((Object)this.numberOfComments);
        }
        if (this.parentCommentId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentCommentId\": ");
            sb.append((Object)this.parentCommentId);
        }
        if (this.text != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"text\": ");
            sb.append("\"");
            sb.append(Comment._escape(this.text));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (Comment._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Comment._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

