/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.AggregateRating;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents a wiki page.", value="WikiPage")
@JsonFilter(value="Liferay.Vulcan")
@Schema(description="Represents a wiki page.", requiredProperties={"encodingFormat", "headline"})
@XmlRootElement(name="WikiPage")
public class WikiPage
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @GraphQLField(description="The blog post's average rating.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The blog post's average rating.") AggregateRating aggregateRating;
    @GraphQLField(description="The wiki page's content.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The wiki page's content.") String content;
    @GraphQLField(description="The wiki page's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The wiki page's creator.") Creator creator;
    @GraphQLField(description="A list of the custom fields associated with the wiki page.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of the custom fields associated with the wiki page.") CustomField[] customFields;
    @GraphQLField(description="The date the wiki page was created.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The date the wiki page was created.") Date dateCreated;
    @GraphQLField(description="The last time any of the wiki page's fields changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time any of the wiki page's fields changed.") Date dateModified;
    @GraphQLField(description="The wiki page's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The wiki page's description.") String description;
    @GraphQLField(description="The wiki page's media format (e.g., HTML, BBCode, etc.).")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The wiki page's media format (e.g., HTML, BBCode, etc.).") @NotEmpty String encodingFormat;
    @GraphQLField(description="The wiki page's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The wiki page's external reference code.") String externalReferenceCode;
    @GraphQLField(description="The wiki page's main title.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The wiki page's main title.") @NotEmpty String headline;
    @GraphQLField(description="The wiki page's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The wiki page's ID.") Long id;
    @GraphQLField(description="A list of keywords describing the blog post.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="A list of keywords describing the blog post.") String[] keywords;
    @GraphQLField(description="The wiki page's number attachments.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The wiki page's number attachments.") Integer numberOfAttachments;
    @GraphQLField(description="The number of child wiki page on this wiki page.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of child wiki page on this wiki page.") Integer numberOfWikiPages;
    @GraphQLField(description="The ID of the wiki page's parent, if it exists.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The ID of the wiki page's parent, if it exists.") Long parentWikiPageId;
    @GraphQLField(description="A list of related contents to this wiki page.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A list of related contents to this wiki page.") RelatedContent[] relatedContents;
    @GraphQLField(description="The ID of the site to which this wiki page is scoped.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The ID of the site to which this wiki page is scoped.") Long siteId;
    @GraphQLField(description="A flag that indicates whether the user making the requests is subscribed to this wiki page.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A flag that indicates whether the user making the requests is subscribed to this wiki page.") Boolean subscribed;
    @GraphQLField(description="The categories associated with this wiki page.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The categories associated with this wiki page.") TaxonomyCategoryBrief[] taxonomyCategoryBriefs;
    @GraphQLField(description="A write-only field that adds `TaxonomyCategory` instances to the wiki page.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only field that adds `TaxonomyCategory` instances to the wiki page.") Long[] taxonomyCategoryIds;
    @GraphQLField(description="A write-only property that specifies the default permissions.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only property that specifies the default permissions.") ViewableBy viewableBy;
    @GraphQLField(description="The ID of the wiki node to which the wiki page belongs.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The ID of the wiki node to which the wiki page belongs.") Long wikiNodeId;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.delivery.dto.v1_0.WikiPage", name="x-class-name")
    public String xClassName;

    public static WikiPage toDTO(String json) {
        return (WikiPage)ObjectMapperUtil.readValue(WikiPage.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The blog post's average rating.")
    @Valid
    public AggregateRating getAggregateRating() {
        return this.aggregateRating;
    }

    public void setAggregateRating(AggregateRating aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    @JsonIgnore
    public void setAggregateRating(UnsafeSupplier<AggregateRating, Exception> aggregateRatingUnsafeSupplier) {
        try {
            this.aggregateRating = (AggregateRating)aggregateRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's content.")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @JsonIgnore
    public void setContent(UnsafeSupplier<String, Exception> contentUnsafeSupplier) {
        try {
            this.content = (String)contentUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's creator.")
    @Valid
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of the custom fields associated with the wiki page.")
    @Valid
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the wiki page was created.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time any of the wiki page's fields changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        try {
            this.description = (String)descriptionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's media format (e.g., HTML, BBCode, etc.).")
    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public void setEncodingFormat(UnsafeSupplier<String, Exception> encodingFormatUnsafeSupplier) {
        try {
            this.encodingFormat = (String)encodingFormatUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's external reference code.")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's main title.")
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    @JsonIgnore
    public void setHeadline(UnsafeSupplier<String, Exception> headlineUnsafeSupplier) {
        try {
            this.headline = (String)headlineUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the blog post.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = (String[])keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The wiki page's number attachments.")
    public Integer getNumberOfAttachments() {
        return this.numberOfAttachments;
    }

    public void setNumberOfAttachments(Integer numberOfAttachments) {
        this.numberOfAttachments = numberOfAttachments;
    }

    @JsonIgnore
    public void setNumberOfAttachments(UnsafeSupplier<Integer, Exception> numberOfAttachmentsUnsafeSupplier) {
        try {
            this.numberOfAttachments = (Integer)numberOfAttachmentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of child wiki page on this wiki page.")
    public Integer getNumberOfWikiPages() {
        return this.numberOfWikiPages;
    }

    public void setNumberOfWikiPages(Integer numberOfWikiPages) {
        this.numberOfWikiPages = numberOfWikiPages;
    }

    @JsonIgnore
    public void setNumberOfWikiPages(UnsafeSupplier<Integer, Exception> numberOfWikiPagesUnsafeSupplier) {
        try {
            this.numberOfWikiPages = (Integer)numberOfWikiPagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the wiki page's parent, if it exists.")
    public Long getParentWikiPageId() {
        return this.parentWikiPageId;
    }

    public void setParentWikiPageId(Long parentWikiPageId) {
        this.parentWikiPageId = parentWikiPageId;
    }

    @JsonIgnore
    public void setParentWikiPageId(UnsafeSupplier<Long, Exception> parentWikiPageIdUnsafeSupplier) {
        try {
            this.parentWikiPageId = (Long)parentWikiPageIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of related contents to this wiki page.")
    @Valid
    public RelatedContent[] getRelatedContents() {
        return this.relatedContents;
    }

    public void setRelatedContents(RelatedContent[] relatedContents) {
        this.relatedContents = relatedContents;
    }

    @JsonIgnore
    public void setRelatedContents(UnsafeSupplier<RelatedContent[], Exception> relatedContentsUnsafeSupplier) {
        try {
            this.relatedContents = (RelatedContent[])relatedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this wiki page is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether the user making the requests is subscribed to this wiki page.")
    public Boolean getSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    @JsonIgnore
    public void setSubscribed(UnsafeSupplier<Boolean, Exception> subscribedUnsafeSupplier) {
        try {
            this.subscribed = (Boolean)subscribedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The categories associated with this wiki page.")
    @Valid
    public TaxonomyCategoryBrief[] getTaxonomyCategoryBriefs() {
        return this.taxonomyCategoryBriefs;
    }

    public void setTaxonomyCategoryBriefs(TaxonomyCategoryBrief[] taxonomyCategoryBriefs) {
        this.taxonomyCategoryBriefs = taxonomyCategoryBriefs;
    }

    @JsonIgnore
    public void setTaxonomyCategoryBriefs(UnsafeSupplier<TaxonomyCategoryBrief[], Exception> taxonomyCategoryBriefsUnsafeSupplier) {
        try {
            this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])taxonomyCategoryBriefsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only field that adds `TaxonomyCategory` instances to the wiki page.")
    public Long[] getTaxonomyCategoryIds() {
        return this.taxonomyCategoryIds;
    }

    public void setTaxonomyCategoryIds(Long[] taxonomyCategoryIds) {
        this.taxonomyCategoryIds = taxonomyCategoryIds;
    }

    @JsonIgnore
    public void setTaxonomyCategoryIds(UnsafeSupplier<Long[], Exception> taxonomyCategoryIdsUnsafeSupplier) {
        try {
            this.taxonomyCategoryIds = (Long[])taxonomyCategoryIdsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the default permissions.")
    @Valid
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = (ViewableBy)((Object)viewableByUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the wiki node to which the wiki page belongs.")
    public Long getWikiNodeId() {
        return this.wikiNodeId;
    }

    public void setWikiNodeId(Long wikiNodeId) {
        this.wikiNodeId = wikiNodeId;
    }

    @JsonIgnore
    public void setWikiNodeId(UnsafeSupplier<Long, Exception> wikiNodeIdUnsafeSupplier) {
        try {
            this.wikiNodeId = (Long)wikiNodeIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WikiPage)) {
            return false;
        }
        WikiPage wikiPage = (WikiPage)object;
        return Objects.equals(this.toString(), wikiPage.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(WikiPage._toJSON(this.actions));
        }
        if (this.aggregateRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(this.aggregateRating));
        }
        if (this.content != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"content\": ");
            sb.append("\"");
            sb.append(WikiPage._escape(this.content));
            sb.append("\"");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.description != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(WikiPage._escape(this.description));
            sb.append("\"");
        }
        if (this.encodingFormat != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(WikiPage._escape(this.encodingFormat));
            sb.append("\"");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(WikiPage._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.headline != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"headline\": ");
            sb.append("\"");
            sb.append(WikiPage._escape(this.headline));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(WikiPage._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.numberOfAttachments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfAttachments\": ");
            sb.append((Object)this.numberOfAttachments);
        }
        if (this.numberOfWikiPages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfWikiPages\": ");
            sb.append((Object)this.numberOfWikiPages);
        }
        if (this.parentWikiPageId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentWikiPageId\": ");
            sb.append((Object)this.parentWikiPageId);
        }
        if (this.relatedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < this.relatedContents.length; ++i) {
                sb.append(String.valueOf(this.relatedContents[i]));
                if (i + 1 >= this.relatedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        if (this.subscribed != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"subscribed\": ");
            sb.append((Object)this.subscribed);
        }
        if (this.taxonomyCategoryBriefs != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryBriefs\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryBriefs.length; ++i) {
                sb.append(String.valueOf(this.taxonomyCategoryBriefs[i]));
                if (i + 1 >= this.taxonomyCategoryBriefs.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.taxonomyCategoryIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryIds\": ");
            sb.append("[");
            for (i = 0; i < this.taxonomyCategoryIds.length; ++i) {
                sb.append((Object)this.taxonomyCategoryIds[i]);
                if (i + 1 >= this.taxonomyCategoryIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        if (this.wikiNodeId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"wikiNodeId\": ");
            sb.append((Object)this.wikiNodeId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (WikiPage._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(WikiPage._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ViewableBy")
    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

