/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.dto.v1_0;

import com.liferay.headless.delivery.client.function.UnsafeSupplier;
import com.liferay.headless.delivery.client.serdes.v1_0.CollectionConfigSerDes;
import java.io.Serializable;
import java.util.Objects;

public class CollectionConfig
implements Cloneable,
Serializable {
    protected Object collectionReference;
    protected CollectionType collectionType;

    public static CollectionConfig toDTO(String json) {
        return CollectionConfigSerDes.toDTO(json);
    }

    public Object getCollectionReference() {
        return this.collectionReference;
    }

    public void setCollectionReference(Object collectionReference) {
        this.collectionReference = collectionReference;
    }

    public void setCollectionReference(UnsafeSupplier<Object, Exception> collectionReferenceUnsafeSupplier) {
        try {
            this.collectionReference = collectionReferenceUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public String getCollectionTypeAsString() {
        if (this.collectionType == null) {
            return null;
        }
        return this.collectionType.toString();
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public void setCollectionType(UnsafeSupplier<CollectionType, Exception> collectionTypeUnsafeSupplier) {
        try {
            this.collectionType = collectionTypeUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CollectionConfig clone() throws CloneNotSupportedException {
        return (CollectionConfig)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CollectionConfig)) {
            return false;
        }
        CollectionConfig collectionConfig = (CollectionConfig)object;
        return Objects.equals(this.toString(), collectionConfig.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return CollectionConfigSerDes.toJSON(this);
    }

    public static enum CollectionType {
        COLLECTION("Collection"),
        COLLECTION_PROVIDER("CollectionProvider");

        private final String _value;

        public static CollectionType create(String value) {
            for (CollectionType collectionType : CollectionType.values()) {
                if (!Objects.equals(collectionType.getValue(), value) && !Objects.equals(collectionType.name(), value)) continue;
                return collectionType;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private CollectionType(String value) {
            this._value = value;
        }
    }
}

