/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.serdes.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.AdaptedImage;
import com.liferay.headless.delivery.client.dto.v1_0.CustomField;
import com.liferay.headless.delivery.client.dto.v1_0.Document;
import com.liferay.headless.delivery.client.dto.v1_0.RelatedContent;
import com.liferay.headless.delivery.client.dto.v1_0.RenderedContent;
import com.liferay.headless.delivery.client.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.client.json.BaseJSONParser;
import com.liferay.headless.delivery.client.serdes.v1_0.AdaptedImageSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.AggregateRatingSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.CreatorSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.CustomFieldSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.DocumentTypeSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.RelatedContentSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.RenderedContentSerDes;
import com.liferay.headless.delivery.client.serdes.v1_0.TaxonomyCategoryBriefSerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;

public class DocumentSerDes {
    public static Document toDTO(String json) {
        DocumentJSONParser documentJSONParser = new DocumentJSONParser();
        return (Document)documentJSONParser.parseToDTO(json);
    }

    public static Document[] toDTOs(String json) {
        DocumentJSONParser documentJSONParser = new DocumentJSONParser();
        return (Document[])documentJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Document document) {
        int i;
        if (document == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (document.getActions() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(DocumentSerDes._toJSON(document.getActions()));
        }
        if (document.getAdaptedImages() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"adaptedImages\": ");
            sb.append("[");
            for (i = 0; i < document.getAdaptedImages().length; ++i) {
                sb.append(String.valueOf(document.getAdaptedImages()[i]));
                if (i + 1 >= document.getAdaptedImages().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (document.getAggregateRating() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(document.getAggregateRating()));
        }
        if (document.getAssetLibraryKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"assetLibraryKey\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getAssetLibraryKey()));
            sb.append("\"");
        }
        if (document.getContentUrl() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentUrl\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getContentUrl()));
            sb.append("\"");
        }
        if (document.getContentValue() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"contentValue\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getContentValue()));
            sb.append("\"");
        }
        if (document.getCreator() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(document.getCreator()));
        }
        if (document.getCustomFields() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < document.getCustomFields().length; ++i) {
                sb.append(String.valueOf(document.getCustomFields()[i]));
                if (i + 1 >= document.getCustomFields().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (document.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(document.getDateCreated()));
            sb.append("\"");
        }
        if (document.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(document.getDateModified()));
            sb.append("\"");
        }
        if (document.getDescription() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getDescription()));
            sb.append("\"");
        }
        if (document.getDocumentFolderId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"documentFolderId\": ");
            sb.append(document.getDocumentFolderId());
        }
        if (document.getDocumentType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"documentType\": ");
            sb.append(String.valueOf(document.getDocumentType()));
        }
        if (document.getEncodingFormat() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getEncodingFormat()));
            sb.append("\"");
        }
        if (document.getExternalReferenceCode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getExternalReferenceCode()));
            sb.append("\"");
        }
        if (document.getFileExtension() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"fileExtension\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getFileExtension()));
            sb.append("\"");
        }
        if (document.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(document.getId());
        }
        if (document.getKeywords() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < document.getKeywords().length; ++i) {
                sb.append("\"");
                sb.append(DocumentSerDes._escape(document.getKeywords()[i]));
                sb.append("\"");
                if (i + 1 >= document.getKeywords().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (document.getNumberOfComments() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfComments\": ");
            sb.append(document.getNumberOfComments());
        }
        if (document.getRelatedContents() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < document.getRelatedContents().length; ++i) {
                sb.append(String.valueOf(document.getRelatedContents()[i]));
                if (i + 1 >= document.getRelatedContents().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (document.getRenderedContents() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"renderedContents\": ");
            sb.append("[");
            for (i = 0; i < document.getRenderedContents().length; ++i) {
                sb.append(String.valueOf(document.getRenderedContents()[i]));
                if (i + 1 >= document.getRenderedContents().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (document.getSiteId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append(document.getSiteId());
        }
        if (document.getSizeInBytes() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sizeInBytes\": ");
            sb.append(document.getSizeInBytes());
        }
        if (document.getTaxonomyCategoryBriefs() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryBriefs\": ");
            sb.append("[");
            for (i = 0; i < document.getTaxonomyCategoryBriefs().length; ++i) {
                sb.append(String.valueOf(document.getTaxonomyCategoryBriefs()[i]));
                if (i + 1 >= document.getTaxonomyCategoryBriefs().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (document.getTaxonomyCategoryIds() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxonomyCategoryIds\": ");
            sb.append("[");
            for (i = 0; i < document.getTaxonomyCategoryIds().length; ++i) {
                sb.append(document.getTaxonomyCategoryIds()[i]);
                if (i + 1 >= document.getTaxonomyCategoryIds().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (document.getTitle() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(DocumentSerDes._escape(document.getTitle()));
            sb.append("\"");
        }
        if (document.getViewableBy() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)document.getViewableBy());
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        DocumentJSONParser documentJSONParser = new DocumentJSONParser();
        return documentJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Document document) {
        if (document == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (document.getActions() == null) {
            map.put("actions", null);
        } else {
            map.put("actions", String.valueOf(document.getActions()));
        }
        if (document.getAdaptedImages() == null) {
            map.put("adaptedImages", null);
        } else {
            map.put("adaptedImages", String.valueOf(document.getAdaptedImages()));
        }
        if (document.getAggregateRating() == null) {
            map.put("aggregateRating", null);
        } else {
            map.put("aggregateRating", String.valueOf(document.getAggregateRating()));
        }
        if (document.getAssetLibraryKey() == null) {
            map.put("assetLibraryKey", null);
        } else {
            map.put("assetLibraryKey", String.valueOf(document.getAssetLibraryKey()));
        }
        if (document.getContentUrl() == null) {
            map.put("contentUrl", null);
        } else {
            map.put("contentUrl", String.valueOf(document.getContentUrl()));
        }
        if (document.getContentValue() == null) {
            map.put("contentValue", null);
        } else {
            map.put("contentValue", String.valueOf(document.getContentValue()));
        }
        if (document.getCreator() == null) {
            map.put("creator", null);
        } else {
            map.put("creator", String.valueOf(document.getCreator()));
        }
        if (document.getCustomFields() == null) {
            map.put("customFields", null);
        } else {
            map.put("customFields", String.valueOf(document.getCustomFields()));
        }
        if (document.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(document.getDateCreated()));
        }
        if (document.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(document.getDateModified()));
        }
        if (document.getDescription() == null) {
            map.put("description", null);
        } else {
            map.put("description", String.valueOf(document.getDescription()));
        }
        if (document.getDocumentFolderId() == null) {
            map.put("documentFolderId", null);
        } else {
            map.put("documentFolderId", String.valueOf(document.getDocumentFolderId()));
        }
        if (document.getDocumentType() == null) {
            map.put("documentType", null);
        } else {
            map.put("documentType", String.valueOf(document.getDocumentType()));
        }
        if (document.getEncodingFormat() == null) {
            map.put("encodingFormat", null);
        } else {
            map.put("encodingFormat", String.valueOf(document.getEncodingFormat()));
        }
        if (document.getExternalReferenceCode() == null) {
            map.put("externalReferenceCode", null);
        } else {
            map.put("externalReferenceCode", String.valueOf(document.getExternalReferenceCode()));
        }
        if (document.getFileExtension() == null) {
            map.put("fileExtension", null);
        } else {
            map.put("fileExtension", String.valueOf(document.getFileExtension()));
        }
        if (document.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(document.getId()));
        }
        if (document.getKeywords() == null) {
            map.put("keywords", null);
        } else {
            map.put("keywords", String.valueOf(document.getKeywords()));
        }
        if (document.getNumberOfComments() == null) {
            map.put("numberOfComments", null);
        } else {
            map.put("numberOfComments", String.valueOf(document.getNumberOfComments()));
        }
        if (document.getRelatedContents() == null) {
            map.put("relatedContents", null);
        } else {
            map.put("relatedContents", String.valueOf(document.getRelatedContents()));
        }
        if (document.getRenderedContents() == null) {
            map.put("renderedContents", null);
        } else {
            map.put("renderedContents", String.valueOf(document.getRenderedContents()));
        }
        if (document.getSiteId() == null) {
            map.put("siteId", null);
        } else {
            map.put("siteId", String.valueOf(document.getSiteId()));
        }
        if (document.getSizeInBytes() == null) {
            map.put("sizeInBytes", null);
        } else {
            map.put("sizeInBytes", String.valueOf(document.getSizeInBytes()));
        }
        if (document.getTaxonomyCategoryBriefs() == null) {
            map.put("taxonomyCategoryBriefs", null);
        } else {
            map.put("taxonomyCategoryBriefs", String.valueOf(document.getTaxonomyCategoryBriefs()));
        }
        if (document.getTaxonomyCategoryIds() == null) {
            map.put("taxonomyCategoryIds", null);
        } else {
            map.put("taxonomyCategoryIds", String.valueOf(document.getTaxonomyCategoryIds()));
        }
        if (document.getTitle() == null) {
            map.put("title", null);
        } else {
            map.put("title", String.valueOf(document.getTitle()));
        }
        if (document.getViewableBy() == null) {
            map.put("viewableBy", null);
        } else {
            map.put("viewableBy", String.valueOf((Object)document.getViewableBy()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(DocumentSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(DocumentSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(DocumentSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class DocumentJSONParser
    extends BaseJSONParser<Document> {
        @Override
        protected Document createDTO() {
            return new Document();
        }

        protected Document[] createDTOArray(int size) {
            return new Document[size];
        }

        @Override
        protected void setField(Document document, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "actions")) {
                if (jsonParserFieldValue != null) {
                    document.setActions(DocumentSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "adaptedImages")) {
                if (jsonParserFieldValue != null) {
                    document.setAdaptedImages((AdaptedImage[])Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(object -> AdaptedImageSerDes.toDTO(object)).toArray(AdaptedImage[]::new));
                }
            } else if (Objects.equals(jsonParserFieldName, "aggregateRating")) {
                if (jsonParserFieldValue != null) {
                    document.setAggregateRating(AggregateRatingSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "assetLibraryKey")) {
                if (jsonParserFieldValue != null) {
                    document.setAssetLibraryKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "contentUrl")) {
                if (jsonParserFieldValue != null) {
                    document.setContentUrl((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "contentValue")) {
                if (jsonParserFieldValue != null) {
                    document.setContentValue((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "creator")) {
                if (jsonParserFieldValue != null) {
                    document.setCreator(CreatorSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "customFields")) {
                if (jsonParserFieldValue != null) {
                    document.setCustomFields((CustomField[])Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(object -> CustomFieldSerDes.toDTO(object)).toArray(CustomField[]::new));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    document.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    document.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "description")) {
                if (jsonParserFieldValue != null) {
                    document.setDescription((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "documentFolderId")) {
                if (jsonParserFieldValue != null) {
                    document.setDocumentFolderId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "documentType")) {
                if (jsonParserFieldValue != null) {
                    document.setDocumentType(DocumentTypeSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "encodingFormat")) {
                if (jsonParserFieldValue != null) {
                    document.setEncodingFormat((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    document.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "fileExtension")) {
                if (jsonParserFieldValue != null) {
                    document.setFileExtension((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    document.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "keywords")) {
                if (jsonParserFieldValue != null) {
                    document.setKeywords(this.toStrings((Object[])jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "numberOfComments")) {
                if (jsonParserFieldValue != null) {
                    document.setNumberOfComments(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "relatedContents")) {
                if (jsonParserFieldValue != null) {
                    document.setRelatedContents((RelatedContent[])Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(object -> RelatedContentSerDes.toDTO(object)).toArray(RelatedContent[]::new));
                }
            } else if (Objects.equals(jsonParserFieldName, "renderedContents")) {
                if (jsonParserFieldValue != null) {
                    document.setRenderedContents((RenderedContent[])Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(object -> RenderedContentSerDes.toDTO(object)).toArray(RenderedContent[]::new));
                }
            } else if (Objects.equals(jsonParserFieldName, "siteId")) {
                if (jsonParserFieldValue != null) {
                    document.setSiteId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "sizeInBytes")) {
                if (jsonParserFieldValue != null) {
                    document.setSizeInBytes(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "taxonomyCategoryBriefs")) {
                if (jsonParserFieldValue != null) {
                    document.setTaxonomyCategoryBriefs((TaxonomyCategoryBrief[])Stream.of(this.toStrings((Object[])jsonParserFieldValue)).map(object -> TaxonomyCategoryBriefSerDes.toDTO(object)).toArray(TaxonomyCategoryBrief[]::new));
                }
            } else if (Objects.equals(jsonParserFieldName, "taxonomyCategoryIds")) {
                if (jsonParserFieldValue != null) {
                    document.setTaxonomyCategoryIds(this.toLongs((Object[])jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "title")) {
                if (jsonParserFieldValue != null) {
                    document.setTitle((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "viewableBy") && jsonParserFieldValue != null) {
                document.setViewableBy(Document.ViewableBy.create((String)jsonParserFieldValue));
            }
        }
    }
}

