/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.serdes.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.Segment;
import com.liferay.headless.delivery.client.json.BaseJSONParser;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class SegmentSerDes {
    public static Segment toDTO(String json) {
        SegmentJSONParser segmentJSONParser = new SegmentJSONParser();
        return (Segment)segmentJSONParser.parseToDTO(json);
    }

    public static Segment[] toDTOs(String json) {
        SegmentJSONParser segmentJSONParser = new SegmentJSONParser();
        return (Segment[])segmentJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Segment segment) {
        if (segment == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (segment.getActive() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"active\": ");
            sb.append(segment.getActive());
        }
        if (segment.getCriteria() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"criteria\": ");
            sb.append("\"");
            sb.append(SegmentSerDes._escape(segment.getCriteria()));
            sb.append("\"");
        }
        if (segment.getCriteriaValue() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"criteriaValue\": ");
            sb.append(SegmentSerDes._toJSON(segment.getCriteriaValue()));
        }
        if (segment.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(segment.getDateCreated()));
            sb.append("\"");
        }
        if (segment.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(segment.getDateModified()));
            sb.append("\"");
        }
        if (segment.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(segment.getId());
        }
        if (segment.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(SegmentSerDes._escape(segment.getName()));
            sb.append("\"");
        }
        if (segment.getSiteId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append(segment.getSiteId());
        }
        if (segment.getSource() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"source\": ");
            sb.append("\"");
            sb.append(SegmentSerDes._escape(segment.getSource()));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        SegmentJSONParser segmentJSONParser = new SegmentJSONParser();
        return segmentJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Segment segment) {
        if (segment == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
        if (segment.getActive() == null) {
            map.put("active", null);
        } else {
            map.put("active", String.valueOf(segment.getActive()));
        }
        if (segment.getCriteria() == null) {
            map.put("criteria", null);
        } else {
            map.put("criteria", String.valueOf(segment.getCriteria()));
        }
        if (segment.getCriteriaValue() == null) {
            map.put("criteriaValue", null);
        } else {
            map.put("criteriaValue", String.valueOf(segment.getCriteriaValue()));
        }
        if (segment.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(segment.getDateCreated()));
        }
        if (segment.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(segment.getDateModified()));
        }
        if (segment.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(segment.getId()));
        }
        if (segment.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(segment.getName()));
        }
        if (segment.getSiteId() == null) {
            map.put("siteId", null);
        } else {
            map.put("siteId", String.valueOf(segment.getSiteId()));
        }
        if (segment.getSource() == null) {
            map.put("source", null);
        } else {
            map.put("source", String.valueOf(segment.getSource()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(SegmentSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(SegmentSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(SegmentSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class SegmentJSONParser
    extends BaseJSONParser<Segment> {
        @Override
        protected Segment createDTO() {
            return new Segment();
        }

        protected Segment[] createDTOArray(int size) {
            return new Segment[size];
        }

        @Override
        protected void setField(Segment segment, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "active")) {
                if (jsonParserFieldValue != null) {
                    segment.setActive((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "criteria")) {
                if (jsonParserFieldValue != null) {
                    segment.setCriteria((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "criteriaValue")) {
                if (jsonParserFieldValue != null) {
                    segment.setCriteriaValue(SegmentSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    segment.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    segment.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    segment.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    segment.setName((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "siteId")) {
                if (jsonParserFieldValue != null) {
                    segment.setSiteId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "source") && jsonParserFieldValue != null) {
                segment.setSource((String)jsonParserFieldValue);
            }
        }
    }
}

