/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.resource.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.KnowledgeBaseAttachment;
import com.liferay.headless.delivery.client.http.HttpInvoker;
import com.liferay.headless.delivery.client.pagination.Page;
import com.liferay.headless.delivery.client.problem.Problem;
import com.liferay.headless.delivery.client.serdes.v1_0.KnowledgeBaseAttachmentSerDes;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface KnowledgeBaseAttachmentResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<KnowledgeBaseAttachment> getKnowledgeBaseArticleKnowledgeBaseAttachmentsPage(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getKnowledgeBaseArticleKnowledgeBaseAttachmentsPageHttpResponse(Long var1) throws Exception;

    public KnowledgeBaseAttachment postKnowledgeBaseArticleKnowledgeBaseAttachment(Long var1, KnowledgeBaseAttachment var2, Map<String, File> var3) throws Exception;

    public HttpInvoker.HttpResponse postKnowledgeBaseArticleKnowledgeBaseAttachmentHttpResponse(Long var1, KnowledgeBaseAttachment var2, Map<String, File> var3) throws Exception;

    public void postKnowledgeBaseArticleKnowledgeBaseAttachmentBatch(Long var1, KnowledgeBaseAttachment var2, Map<String, File> var3, String var4, Object var5) throws Exception;

    public HttpInvoker.HttpResponse postKnowledgeBaseArticleKnowledgeBaseAttachmentBatchHttpResponse(Long var1, KnowledgeBaseAttachment var2, Map<String, File> var3, String var4, Object var5) throws Exception;

    public void deleteKnowledgeBaseAttachment(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteKnowledgeBaseAttachmentHttpResponse(Long var1) throws Exception;

    public void deleteKnowledgeBaseAttachmentBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deleteKnowledgeBaseAttachmentBatchHttpResponse(String var1, Object var2) throws Exception;

    public KnowledgeBaseAttachment getKnowledgeBaseAttachment(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getKnowledgeBaseAttachmentHttpResponse(Long var1) throws Exception;

    public static class KnowledgeBaseAttachmentResourceImpl
    implements KnowledgeBaseAttachmentResource {
        private static final Logger _logger = Logger.getLogger(KnowledgeBaseAttachmentResource.class.getName());
        private Builder _builder;

        @Override
        public Page<KnowledgeBaseAttachment> getKnowledgeBaseArticleKnowledgeBaseAttachmentsPage(Long knowledgeBaseArticleId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getKnowledgeBaseArticleKnowledgeBaseAttachmentsPageHttpResponse(knowledgeBaseArticleId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, KnowledgeBaseAttachmentSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getKnowledgeBaseArticleKnowledgeBaseAttachmentsPageHttpResponse(Long knowledgeBaseArticleId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-delivery/v1.0/knowledge-base-articles/{knowledgeBaseArticleId}/knowledge-base-attachments");
            httpInvoker.path("knowledgeBaseArticleId", knowledgeBaseArticleId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseAttachment postKnowledgeBaseArticleKnowledgeBaseAttachment(Long knowledgeBaseArticleId, KnowledgeBaseAttachment knowledgeBaseAttachment, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postKnowledgeBaseArticleKnowledgeBaseAttachmentHttpResponse(knowledgeBaseArticleId, knowledgeBaseAttachment, multipartFiles);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseAttachmentSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postKnowledgeBaseArticleKnowledgeBaseAttachmentHttpResponse(Long knowledgeBaseArticleId, KnowledgeBaseAttachment knowledgeBaseAttachment, Map<String, File> multipartFiles) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.multipart();
            httpInvoker.part("knowledgeBaseAttachment", KnowledgeBaseAttachmentSerDes.toJSON(knowledgeBaseAttachment));
            for (Map.Entry<String, File> entry : multipartFiles.entrySet()) {
                httpInvoker.part(entry.getKey(), entry.getValue());
            }
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, File> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), (String)((Object)entry.getValue()));
            }
            for (Map.Entry<String, File> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), (String)((Object)entry.getValue()));
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-delivery/v1.0/knowledge-base-articles/{knowledgeBaseArticleId}/knowledge-base-attachments");
            httpInvoker.path("knowledgeBaseArticleId", knowledgeBaseArticleId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postKnowledgeBaseArticleKnowledgeBaseAttachmentBatch(Long knowledgeBaseArticleId, KnowledgeBaseAttachment knowledgeBaseAttachment, Map<String, File> multipartFiles, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postKnowledgeBaseArticleKnowledgeBaseAttachmentBatchHttpResponse(knowledgeBaseArticleId, knowledgeBaseAttachment, multipartFiles, callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postKnowledgeBaseArticleKnowledgeBaseAttachmentBatchHttpResponse(Long knowledgeBaseArticleId, KnowledgeBaseAttachment knowledgeBaseAttachment, Map<String, File> multipartFiles, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-delivery/v1.0/knowledge-base-articles/{knowledgeBaseArticleId}/knowledge-base-attachments/batch");
            httpInvoker.path("knowledgeBaseArticleId", knowledgeBaseArticleId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteKnowledgeBaseAttachment(Long knowledgeBaseAttachmentId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteKnowledgeBaseAttachmentHttpResponse(knowledgeBaseAttachmentId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteKnowledgeBaseAttachmentHttpResponse(Long knowledgeBaseAttachmentId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-delivery/v1.0/knowledge-base-attachments/{knowledgeBaseAttachmentId}");
            httpInvoker.path("knowledgeBaseAttachmentId", knowledgeBaseAttachmentId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteKnowledgeBaseAttachmentBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteKnowledgeBaseAttachmentBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteKnowledgeBaseAttachmentBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-delivery/v1.0/knowledge-base-attachments/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public KnowledgeBaseAttachment getKnowledgeBaseAttachment(Long knowledgeBaseAttachmentId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getKnowledgeBaseAttachmentHttpResponse(knowledgeBaseAttachmentId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return KnowledgeBaseAttachmentSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getKnowledgeBaseAttachmentHttpResponse(Long knowledgeBaseAttachmentId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-delivery/v1.0/knowledge-base-attachments/{knowledgeBaseAttachmentId}");
            httpInvoker.path("knowledgeBaseAttachmentId", knowledgeBaseAttachmentId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private KnowledgeBaseAttachmentResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public KnowledgeBaseAttachmentResource build() {
            return new KnowledgeBaseAttachmentResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

