/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.serdes.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.Rating;
import com.liferay.headless.delivery.client.json.BaseJSONParser;
import com.liferay.headless.delivery.client.serdes.v1_0.CreatorSerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class RatingSerDes {
    public static Rating toDTO(String json) {
        RatingJSONParser ratingJSONParser = new RatingJSONParser();
        return (Rating)ratingJSONParser.parseToDTO(json);
    }

    public static Rating[] toDTOs(String json) {
        RatingJSONParser ratingJSONParser = new RatingJSONParser();
        return (Rating[])ratingJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Rating rating) {
        if (rating == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (rating.getActions() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(RatingSerDes._toJSON(rating.getActions()));
        }
        if (rating.getBestRating() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"bestRating\": ");
            sb.append(rating.getBestRating());
        }
        if (rating.getCreator() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(rating.getCreator()));
        }
        if (rating.getDateCreated() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(rating.getDateCreated()));
            sb.append("\"");
        }
        if (rating.getDateModified() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(rating.getDateModified()));
            sb.append("\"");
        }
        if (rating.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(rating.getId());
        }
        if (rating.getRatingValue() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"ratingValue\": ");
            sb.append(rating.getRatingValue());
        }
        if (rating.getWorstRating() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"worstRating\": ");
            sb.append(rating.getWorstRating());
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        RatingJSONParser ratingJSONParser = new RatingJSONParser();
        return ratingJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Rating rating) {
        if (rating == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (rating.getActions() == null) {
            map.put("actions", null);
        } else {
            map.put("actions", String.valueOf(rating.getActions()));
        }
        if (rating.getBestRating() == null) {
            map.put("bestRating", null);
        } else {
            map.put("bestRating", String.valueOf(rating.getBestRating()));
        }
        if (rating.getCreator() == null) {
            map.put("creator", null);
        } else {
            map.put("creator", String.valueOf(rating.getCreator()));
        }
        if (rating.getDateCreated() == null) {
            map.put("dateCreated", null);
        } else {
            map.put("dateCreated", liferayToJSONDateFormat.format(rating.getDateCreated()));
        }
        if (rating.getDateModified() == null) {
            map.put("dateModified", null);
        } else {
            map.put("dateModified", liferayToJSONDateFormat.format(rating.getDateModified()));
        }
        if (rating.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(rating.getId()));
        }
        if (rating.getRatingValue() == null) {
            map.put("ratingValue", null);
        } else {
            map.put("ratingValue", String.valueOf(rating.getRatingValue()));
        }
        if (rating.getWorstRating() == null) {
            map.put("worstRating", null);
        } else {
            map.put("worstRating", String.valueOf(rating.getWorstRating()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(RatingSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(RatingSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(RatingSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class RatingJSONParser
    extends BaseJSONParser<Rating> {
        @Override
        protected Rating createDTO() {
            return new Rating();
        }

        protected Rating[] createDTOArray(int size) {
            return new Rating[size];
        }

        @Override
        protected void setField(Rating rating, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "actions")) {
                if (jsonParserFieldValue != null) {
                    rating.setActions(RatingSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "bestRating")) {
                if (jsonParserFieldValue != null) {
                    rating.setBestRating(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "creator")) {
                if (jsonParserFieldValue != null) {
                    rating.setCreator(CreatorSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateCreated")) {
                if (jsonParserFieldValue != null) {
                    rating.setDateCreated(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "dateModified")) {
                if (jsonParserFieldValue != null) {
                    rating.setDateModified(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    rating.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "ratingValue")) {
                if (jsonParserFieldValue != null) {
                    rating.setRatingValue(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "worstRating") && jsonParserFieldValue != null) {
                rating.setWorstRating(Double.valueOf((String)jsonParserFieldValue));
            }
        }
    }
}

