/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.delivery.client.serdes.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.UserGroupBrief;
import com.liferay.headless.delivery.client.json.BaseJSONParser;

import jakarta.annotation.Generated;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author Javier Gamarra
 * @generated
 */
@Generated("")
public class UserGroupBriefSerDes {

	public static UserGroupBrief toDTO(String json) {
		UserGroupBriefJSONParser userGroupBriefJSONParser =
			new UserGroupBriefJSONParser();

		return userGroupBriefJSONParser.parseToDTO(json);
	}

	public static UserGroupBrief[] toDTOs(String json) {
		UserGroupBriefJSONParser userGroupBriefJSONParser =
			new UserGroupBriefJSONParser();

		return userGroupBriefJSONParser.parseToDTOs(json);
	}

	public static String toJSON(UserGroupBrief userGroupBrief) {
		if (userGroupBrief == null) {
			return "null";
		}

		StringBuilder sb = new StringBuilder();

		sb.append("{");

		if (userGroupBrief.getId() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"id\": ");

			sb.append(userGroupBrief.getId());
		}

		if (userGroupBrief.getName() != null) {
			if (sb.length() > 1) {
				sb.append(", ");
			}

			sb.append("\"name\": ");

			sb.append("\"");

			sb.append(_escape(userGroupBrief.getName()));

			sb.append("\"");
		}

		sb.append("}");

		return sb.toString();
	}

	public static Map<String, Object> toMap(String json) {
		UserGroupBriefJSONParser userGroupBriefJSONParser =
			new UserGroupBriefJSONParser();

		return userGroupBriefJSONParser.parseToMap(json);
	}

	public static Map<String, String> toMap(UserGroupBrief userGroupBrief) {
		if (userGroupBrief == null) {
			return null;
		}

		Map<String, String> map = new TreeMap<>();

		if (userGroupBrief.getId() == null) {
			map.put("id", null);
		}
		else {
			map.put("id", String.valueOf(userGroupBrief.getId()));
		}

		if (userGroupBrief.getName() == null) {
			map.put("name", null);
		}
		else {
			map.put("name", String.valueOf(userGroupBrief.getName()));
		}

		return map;
	}

	public static class UserGroupBriefJSONParser
		extends BaseJSONParser<UserGroupBrief> {

		@Override
		protected UserGroupBrief createDTO() {
			return new UserGroupBrief();
		}

		@Override
		protected UserGroupBrief[] createDTOArray(int size) {
			return new UserGroupBrief[size];
		}

		@Override
		protected boolean parseMaps(String jsonParserFieldName) {
			if (Objects.equals(jsonParserFieldName, "id")) {
				return false;
			}
			else if (Objects.equals(jsonParserFieldName, "name")) {
				return false;
			}

			return false;
		}

		@Override
		protected void setField(
			UserGroupBrief userGroupBrief, String jsonParserFieldName,
			Object jsonParserFieldValue) {

			if (Objects.equals(jsonParserFieldName, "id")) {
				if (jsonParserFieldValue != null) {
					userGroupBrief.setId(
						Long.valueOf((String)jsonParserFieldValue));
				}
			}
			else if (Objects.equals(jsonParserFieldName, "name")) {
				if (jsonParserFieldValue != null) {
					userGroupBrief.setName((String)jsonParserFieldValue);
				}
			}
		}

	}

	private static String _escape(Object object) {
		String string = String.valueOf(object);

		for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
			string = string.replace(strings[0], strings[1]);
		}

		return string;
	}

	private static String _toJSON(Map<String, ?> map) {
		StringBuilder sb = new StringBuilder("{");

		@SuppressWarnings("unchecked")
		Set set = map.entrySet();

		@SuppressWarnings("unchecked")
		Iterator<Map.Entry<String, ?>> iterator = set.iterator();

		while (iterator.hasNext()) {
			Map.Entry<String, ?> entry = iterator.next();

			sb.append("\"");
			sb.append(entry.getKey());
			sb.append("\": ");

			Object value = entry.getValue();

			sb.append(_toJSON(value));

			if (iterator.hasNext()) {
				sb.append(", ");
			}
		}

		sb.append("}");

		return sb.toString();
	}

	private static String _toJSON(Object value) {
		if (value == null) {
			return "null";
		}

		if (value instanceof Map) {
			return _toJSON((Map)value);
		}

		Class<?> clazz = value.getClass();

		if (clazz.isArray()) {
			StringBuilder sb = new StringBuilder("[");

			Object[] values = (Object[])value;

			for (int i = 0; i < values.length; i++) {
				sb.append(_toJSON(values[i]));

				if ((i + 1) < values.length) {
					sb.append(", ");
				}
			}

			sb.append("]");

			return sb.toString();
		}

		if (value instanceof String) {
			return "\"" + _escape(value) + "\"";
		}

		return String.valueOf(value);
	}

}