/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.dto.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.LocalizationConfig;
import com.liferay.headless.delivery.client.function.UnsafeSupplier;
import com.liferay.headless.delivery.client.serdes.v1_0.FormConfigSerDes;
import java.io.Serializable;
import java.util.Objects;

public class FormConfig
implements Cloneable,
Serializable {
    protected Object formReference;
    protected Object formSuccessSubmissionResult;
    protected FormType formType;
    protected LocalizationConfig localizationConfig;
    protected Integer numberOfSteps;

    public static FormConfig toDTO(String json) {
        return FormConfigSerDes.toDTO(json);
    }

    public Object getFormReference() {
        return this.formReference;
    }

    public void setFormReference(Object formReference) {
        this.formReference = formReference;
    }

    public void setFormReference(UnsafeSupplier<Object, Exception> formReferenceUnsafeSupplier) {
        try {
            this.formReference = formReferenceUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getFormSuccessSubmissionResult() {
        return this.formSuccessSubmissionResult;
    }

    public void setFormSuccessSubmissionResult(Object formSuccessSubmissionResult) {
        this.formSuccessSubmissionResult = formSuccessSubmissionResult;
    }

    public void setFormSuccessSubmissionResult(UnsafeSupplier<Object, Exception> formSuccessSubmissionResultUnsafeSupplier) {
        try {
            this.formSuccessSubmissionResult = formSuccessSubmissionResultUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FormType getFormType() {
        return this.formType;
    }

    public String getFormTypeAsString() {
        if (this.formType == null) {
            return null;
        }
        return this.formType.toString();
    }

    public void setFormType(FormType formType) {
        this.formType = formType;
    }

    public void setFormType(UnsafeSupplier<FormType, Exception> formTypeUnsafeSupplier) {
        try {
            this.formType = formTypeUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public LocalizationConfig getLocalizationConfig() {
        return this.localizationConfig;
    }

    public void setLocalizationConfig(LocalizationConfig localizationConfig) {
        this.localizationConfig = localizationConfig;
    }

    public void setLocalizationConfig(UnsafeSupplier<LocalizationConfig, Exception> localizationConfigUnsafeSupplier) {
        try {
            this.localizationConfig = localizationConfigUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public void setNumberOfSteps(Integer numberOfSteps) {
        this.numberOfSteps = numberOfSteps;
    }

    public void setNumberOfSteps(UnsafeSupplier<Integer, Exception> numberOfStepsUnsafeSupplier) {
        try {
            this.numberOfSteps = numberOfStepsUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FormConfig clone() throws CloneNotSupportedException {
        return (FormConfig)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FormConfig)) {
            return false;
        }
        FormConfig formConfig = (FormConfig)object;
        return Objects.equals(this.toString(), formConfig.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return FormConfigSerDes.toJSON(this);
    }

    public static enum FormType {
        SIMPLE("simple"),
        MULTISTEP("multistep");

        private final String _value;

        public static FormType create(String value) {
            for (FormType formType : FormType.values()) {
                if (!Objects.equals(formType.getValue(), value) && !Objects.equals(formType.name(), value)) continue;
                return formType;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private FormType(String value) {
            this._value = value;
        }
    }
}

