/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.client.resource.v1_0;

import com.liferay.headless.delivery.client.dto.v1_0.DocumentMetadataSet;
import com.liferay.headless.delivery.client.http.HttpInvoker;
import com.liferay.headless.delivery.client.pagination.Page;
import com.liferay.headless.delivery.client.pagination.Pagination;
import com.liferay.headless.delivery.client.problem.Problem;
import com.liferay.headless.delivery.client.serdes.v1_0.DocumentMetadataSetSerDes;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface DocumentMetadataSetResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteAssetLibraryDocumentMetadataSetByExternalReferenceCode(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse deleteAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long var1, String var2) throws Exception;

    public void deleteDocumentMetadataSet(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteDocumentMetadataSetHttpResponse(Long var1) throws Exception;

    public void deleteDocumentMetadataSetBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deleteDocumentMetadataSetBatchHttpResponse(String var1, Object var2) throws Exception;

    public void deleteSiteDocumentMetadataSetByExternalReferenceCode(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse deleteSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long var1, String var2) throws Exception;

    public DocumentMetadataSet getAssetLibraryDocumentMetadataSetByExternalReferenceCode(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse getAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long var1, String var2) throws Exception;

    public Page<DocumentMetadataSet> getAssetLibraryDocumentMetadataSetsPage(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getAssetLibraryDocumentMetadataSetsPageHttpResponse(Long var1, Pagination var2) throws Exception;

    public DocumentMetadataSet getDocumentMetadataSet(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getDocumentMetadataSetHttpResponse(Long var1) throws Exception;

    public DocumentMetadataSet getSiteDocumentMetadataSetByExternalReferenceCode(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse getSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long var1, String var2) throws Exception;

    public Page<DocumentMetadataSet> getSiteDocumentMetadataSetsPage(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getSiteDocumentMetadataSetsPageHttpResponse(Long var1, Pagination var2) throws Exception;

    public DocumentMetadataSet postAssetLibraryDocumentMetadataSet(Long var1, DocumentMetadataSet var2) throws Exception;

    public HttpInvoker.HttpResponse postAssetLibraryDocumentMetadataSetHttpResponse(Long var1, DocumentMetadataSet var2) throws Exception;

    public void postAssetLibraryDocumentMetadataSetBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse postAssetLibraryDocumentMetadataSetBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public void postAssetLibraryDocumentMetadataSetsPageExportBatch(Long var1, String var2, String var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse postAssetLibraryDocumentMetadataSetsPageExportBatchHttpResponse(Long var1, String var2, String var3, String var4) throws Exception;

    public DocumentMetadataSet postSiteDocumentMetadataSet(Long var1, DocumentMetadataSet var2) throws Exception;

    public HttpInvoker.HttpResponse postSiteDocumentMetadataSetHttpResponse(Long var1, DocumentMetadataSet var2) throws Exception;

    public void postSiteDocumentMetadataSetBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse postSiteDocumentMetadataSetBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public void postSiteDocumentMetadataSetsPageExportBatch(Long var1, String var2, String var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse postSiteDocumentMetadataSetsPageExportBatchHttpResponse(Long var1, String var2, String var3, String var4) throws Exception;

    public DocumentMetadataSet putAssetLibraryDocumentMetadataSetByExternalReferenceCode(Long var1, String var2, DocumentMetadataSet var3) throws Exception;

    public HttpInvoker.HttpResponse putAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long var1, String var2, DocumentMetadataSet var3) throws Exception;

    public DocumentMetadataSet putSiteDocumentMetadataSetByExternalReferenceCode(Long var1, String var2, DocumentMetadataSet var3) throws Exception;

    public HttpInvoker.HttpResponse putSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long var1, String var2, DocumentMetadataSet var3) throws Exception;

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login;
        private String _password;
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public DocumentMetadataSetResource build() {
            return new DocumentMetadataSetResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }

    public static class DocumentMetadataSetResourceImpl
    implements DocumentMetadataSetResource {
        private static final Logger _logger = Logger.getLogger(DocumentMetadataSetResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteAssetLibraryDocumentMetadataSetByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(assetLibraryId, externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long assetLibraryId, String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/asset-libraries/{assetLibraryId}/document-metadata-sets/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("assetLibraryId", assetLibraryId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void deleteDocumentMetadataSet(Long documentMetadataSetId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteDocumentMetadataSetHttpResponse(documentMetadataSetId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteDocumentMetadataSetHttpResponse(Long documentMetadataSetId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/document-metadata-sets/{documentMetadataSetId}");
            httpInvoker.path("documentMetadataSetId", documentMetadataSetId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void deleteDocumentMetadataSetBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteDocumentMetadataSetBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteDocumentMetadataSetBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/document-metadata-sets/batch");
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void deleteSiteDocumentMetadataSetByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(siteId, externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/document-metadata-sets/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("siteId", siteId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public DocumentMetadataSet getAssetLibraryDocumentMetadataSetByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(assetLibraryId, externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DocumentMetadataSetSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long assetLibraryId, String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/asset-libraries/{assetLibraryId}/document-metadata-sets/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("assetLibraryId", assetLibraryId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<DocumentMetadataSet> getAssetLibraryDocumentMetadataSetsPage(Long assetLibraryId, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getAssetLibraryDocumentMetadataSetsPageHttpResponse(assetLibraryId, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, DocumentMetadataSetSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getAssetLibraryDocumentMetadataSetsPageHttpResponse(Long assetLibraryId, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/asset-libraries/{assetLibraryId}/document-metadata-sets");
            httpInvoker.path("assetLibraryId", assetLibraryId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public DocumentMetadataSet getDocumentMetadataSet(Long documentMetadataSetId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getDocumentMetadataSetHttpResponse(documentMetadataSetId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DocumentMetadataSetSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getDocumentMetadataSetHttpResponse(Long documentMetadataSetId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/document-metadata-sets/{documentMetadataSetId}");
            httpInvoker.path("documentMetadataSetId", documentMetadataSetId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public DocumentMetadataSet getSiteDocumentMetadataSetByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(siteId, externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DocumentMetadataSetSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long siteId, String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/document-metadata-sets/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("siteId", siteId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<DocumentMetadataSet> getSiteDocumentMetadataSetsPage(Long siteId, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getSiteDocumentMetadataSetsPageHttpResponse(siteId, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, DocumentMetadataSetSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getSiteDocumentMetadataSetsPageHttpResponse(Long siteId, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/document-metadata-sets");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public DocumentMetadataSet postAssetLibraryDocumentMetadataSet(Long assetLibraryId, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postAssetLibraryDocumentMetadataSetHttpResponse(assetLibraryId, documentMetadataSet);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DocumentMetadataSetSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postAssetLibraryDocumentMetadataSetHttpResponse(Long assetLibraryId, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(documentMetadataSet.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/asset-libraries/{assetLibraryId}/document-metadata-sets");
            httpInvoker.path("assetLibraryId", assetLibraryId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void postAssetLibraryDocumentMetadataSetBatch(Long assetLibraryId, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postAssetLibraryDocumentMetadataSetBatchHttpResponse(assetLibraryId, callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postAssetLibraryDocumentMetadataSetBatchHttpResponse(Long assetLibraryId, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/asset-libraries/{assetLibraryId}/document-metadata-sets/batch");
            httpInvoker.path("assetLibraryId", assetLibraryId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void postAssetLibraryDocumentMetadataSetsPageExportBatch(Long assetLibraryId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postAssetLibraryDocumentMetadataSetsPageExportBatchHttpResponse(assetLibraryId, callbackURL, contentType, fieldNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postAssetLibraryDocumentMetadataSetsPageExportBatchHttpResponse(Long assetLibraryId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body("[]", "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (contentType != null) {
                httpInvoker.parameter("contentType", String.valueOf(contentType));
            }
            if (fieldNames != null) {
                httpInvoker.parameter("fieldNames", String.valueOf(fieldNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/asset-libraries/{assetLibraryId}/document-metadata-sets/export-batch");
            httpInvoker.path("assetLibraryId", assetLibraryId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public DocumentMetadataSet postSiteDocumentMetadataSet(Long siteId, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteDocumentMetadataSetHttpResponse(siteId, documentMetadataSet);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DocumentMetadataSetSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postSiteDocumentMetadataSetHttpResponse(Long siteId, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(documentMetadataSet.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/document-metadata-sets");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void postSiteDocumentMetadataSetBatch(Long siteId, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteDocumentMetadataSetBatchHttpResponse(siteId, callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postSiteDocumentMetadataSetBatchHttpResponse(Long siteId, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/document-metadata-sets/batch");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void postSiteDocumentMetadataSetsPageExportBatch(Long siteId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postSiteDocumentMetadataSetsPageExportBatchHttpResponse(siteId, callbackURL, contentType, fieldNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postSiteDocumentMetadataSetsPageExportBatchHttpResponse(Long siteId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body("[]", "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (contentType != null) {
                httpInvoker.parameter("contentType", String.valueOf(contentType));
            }
            if (fieldNames != null) {
                httpInvoker.parameter("fieldNames", String.valueOf(fieldNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/document-metadata-sets/export-batch");
            httpInvoker.path("siteId", siteId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public DocumentMetadataSet putAssetLibraryDocumentMetadataSetByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(assetLibraryId, externalReferenceCode, documentMetadataSet);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DocumentMetadataSetSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putAssetLibraryDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long assetLibraryId, String externalReferenceCode, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(documentMetadataSet.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/asset-libraries/{assetLibraryId}/document-metadata-sets/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("assetLibraryId", assetLibraryId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public DocumentMetadataSet putSiteDocumentMetadataSetByExternalReferenceCode(Long siteId, String externalReferenceCode, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(siteId, externalReferenceCode, documentMetadataSet);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return DocumentMetadataSetSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putSiteDocumentMetadataSetByExternalReferenceCodeHttpResponse(Long siteId, String externalReferenceCode, DocumentMetadataSet documentMetadataSet) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(documentMetadataSet.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-delivery/v1.0/sites/{siteId}/document-metadata-sets/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("siteId", siteId);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        private DocumentMetadataSetResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }
}

